/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.neo4j.health;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.reactivestreams.ReactiveResult;
import org.neo4j.driver.reactivestreams.ReactiveSession;
import org.neo4j.driver.summary.ResultSummary;
import org.reactivestreams.Publisher;
import org.springframework.boot.health.contributor.AbstractReactiveHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.neo4j.health.Neo4jHealthDetails;
import org.springframework.boot.neo4j.health.Neo4jHealthDetailsHandler;
import org.springframework.boot.neo4j.health.Neo4jHealthIndicator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public final class Neo4jReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private static final Log logger = LogFactory.getLog(Neo4jReactiveHealthIndicator.class);
    private final Driver driver;
    private final Neo4jHealthDetailsHandler healthDetailsHandler;

    public Neo4jReactiveHealthIndicator(Driver driver) {
        this.driver = driver;
        this.healthDetailsHandler = new Neo4jHealthDetailsHandler();
    }

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return this.runHealthCheckQuery().doOnError(SessionExpiredException.class, ex -> logger.warn((Object)"Neo4j session has expired, retrying one single time to retrieve server health.")).retryWhen((Retry)Retry.max((long)1L).filter(SessionExpiredException.class::isInstance)).map(healthDetails -> {
            this.healthDetailsHandler.addHealthDetails(builder, (Neo4jHealthDetails)healthDetails);
            return builder.build();
        });
    }

    Mono<Neo4jHealthDetails> runHealthCheckQuery() {
        return Mono.using(this::session, this::healthDetails, ReactiveSession::close);
    }

    private ReactiveSession session() {
        return (ReactiveSession)this.driver.session(ReactiveSession.class, Neo4jHealthIndicator.DEFAULT_SESSION_CONFIG);
    }

    private Mono<Neo4jHealthDetails> healthDetails(ReactiveSession session) {
        return Mono.from((Publisher)session.run("CALL dbms.components() YIELD versions, name, edition WHERE name = 'Neo4j Kernel' RETURN edition, versions[0] as version")).flatMap(this::healthDetails);
    }

    private Mono<? extends Neo4jHealthDetails> healthDetails(ReactiveResult result) {
        Flux records = Flux.from((Publisher)result.records());
        Mono summary = Mono.from((Publisher)result.consume());
        Neo4jHealthDetailsBuilder builder = new Neo4jHealthDetailsBuilder();
        return records.single().doOnNext(builder::record).then(summary).map(builder::build);
    }

    private static final class Neo4jHealthDetailsBuilder {
        private Record record;

        private Neo4jHealthDetailsBuilder() {
        }

        void record(Record record) {
            this.record = record;
        }

        private Neo4jHealthDetails build(ResultSummary summary) {
            return new Neo4jHealthDetails(this.record, summary);
        }
    }
}

