/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mongodb.autoconfigure;

import com.mongodb.MongoClientSettings;
import com.mongodb.connection.TransportSettings;
import com.mongodb.reactivestreams.client.MongoClient;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.mongodb.autoconfigure.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.mongodb.autoconfigure.MongoConnectionDetails;
import org.springframework.boot.mongodb.autoconfigure.MongoProperties;
import org.springframework.boot.mongodb.autoconfigure.PropertiesMongoConnectionDetails;
import org.springframework.boot.mongodb.autoconfigure.ReactiveMongoClientFactory;
import org.springframework.boot.mongodb.autoconfigure.StandardMongoClientSettingsBuilderCustomizer;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import reactor.core.publisher.Flux;

@AutoConfiguration
@ConditionalOnClass(value={MongoClient.class, Flux.class})
@EnableConfigurationProperties(value={MongoProperties.class})
public class MongoReactiveAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MongoConnectionDetails.class})
    PropertiesMongoConnectionDetails mongoConnectionDetails(MongoProperties properties, ObjectProvider<SslBundles> sslBundles) {
        return new PropertiesMongoConnectionDetails(properties, (SslBundles)sslBundles.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoClient reactiveStreamsMongoClient(ObjectProvider<MongoClientSettingsBuilderCustomizer> builderCustomizers, MongoClientSettings settings) {
        ReactiveMongoClientFactory factory = new ReactiveMongoClientFactory(builderCustomizers.orderedStream().toList());
        return (MongoClient)factory.createMongoClient(settings);
    }

    static final class NettyDriverMongoClientSettingsBuilderCustomizer
    implements MongoClientSettingsBuilderCustomizer,
    DisposableBean {
        private final ObjectProvider<MongoClientSettings> settings;
        private volatile EventLoopGroup eventLoopGroup;

        NettyDriverMongoClientSettingsBuilderCustomizer(ObjectProvider<MongoClientSettings> settings) {
            this.settings = settings;
        }

        @Override
        public void customize(MongoClientSettings.Builder builder) {
            if (!this.isCustomTransportConfiguration((MongoClientSettings)this.settings.getIfAvailable())) {
                this.eventLoopGroup = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
                builder.transportSettings((TransportSettings)TransportSettings.nettyBuilder().eventLoopGroup(this.eventLoopGroup).build());
            }
        }

        public void destroy() {
            EventLoopGroup eventLoopGroup = this.eventLoopGroup;
            if (eventLoopGroup != null) {
                eventLoopGroup.shutdownGracefully().awaitUninterruptibly();
                this.eventLoopGroup = null;
            }
        }

        private boolean isCustomTransportConfiguration(MongoClientSettings settings) {
            return settings != null && settings.getTransportSettings() != null;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SocketChannel.class, NioIoHandler.class})
    static class NettyDriverConfiguration {
        NettyDriverConfiguration() {
        }

        @Bean
        @Order(value=-2147483648)
        NettyDriverMongoClientSettingsBuilderCustomizer nettyDriverCustomizer(ObjectProvider<MongoClientSettings> settings) {
            return new NettyDriverMongoClientSettingsBuilderCustomizer(settings);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={MongoClientSettings.class})
    static class MongoClientSettingsConfiguration {
        MongoClientSettingsConfiguration() {
        }

        @Bean
        MongoClientSettings mongoClientSettings() {
            return MongoClientSettings.builder().build();
        }

        @Bean
        StandardMongoClientSettingsBuilderCustomizer standardMongoSettingsCustomizer(MongoProperties properties, MongoConnectionDetails connectionDetails) {
            return new StandardMongoClientSettingsBuilderCustomizer(connectionDetails, properties.getUuidRepresentation());
        }
    }
}

