/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.testcontainers.otlp;

import org.springframework.boot.micrometer.tracing.autoconfigure.otlp.OtlpTracingConnectionDetails;
import org.springframework.boot.micrometer.tracing.autoconfigure.otlp.Transport;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.grafana.LgtmStackContainer;

class GrafanaOpenTelemetryTracingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<LgtmStackContainer, OtlpTracingConnectionDetails> {
    GrafanaOpenTelemetryTracingContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[]{"org.springframework.boot.micrometer.tracing.autoconfigure.otlp.OtlpTracingAutoConfiguration"});
    }

    protected OtlpTracingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
        return new OpenTelemetryTracingContainerConnectionDetails(source);
    }

    private static final class OpenTelemetryTracingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<LgtmStackContainer>
    implements OtlpTracingConnectionDetails {
        private OpenTelemetryTracingContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
            super(source);
        }

        @Override
        public String getUrl(Transport transport) {
            String url = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> ((LgtmStackContainer)this.getContainer()).getOtlpHttpUrl();
                case Transport.GRPC -> ((LgtmStackContainer)this.getContainer()).getOtlpGrpcUrl();
            };
            return "%s/v1/traces".formatted(url);
        }
    }
}

