/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.autoconfigure;

import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.otel.bridge.OtelBaggageManager;
import io.micrometer.tracing.otel.bridge.OtelCurrentTraceContext;
import io.micrometer.tracing.otel.bridge.Slf4JBaggageEventListener;
import io.micrometer.tracing.otel.propagation.BaggageTextMapPropagator;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.tracing.autoconfigure.CompositeTextMapPropagator;
import org.springframework.boot.micrometer.tracing.autoconfigure.ConditionalOnEnabledTracing;
import org.springframework.boot.micrometer.tracing.autoconfigure.TracingProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

class OpenTelemetryPropagationConfigurations {
    OpenTelemetryPropagationConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    static class NoPropagation {
        NoPropagation() {
        }

        @Bean
        @ConditionalOnMissingBean
        TextMapPropagator noopTextMapPropagator() {
            return TextMapPropagator.noop();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBooleanProperty(name={"management.tracing.baggage.enabled"}, matchIfMissing=true)
    @EnableConfigurationProperties(value={TracingProperties.class})
    static class PropagationWithBaggage {
        private final TracingProperties tracingProperties;

        PropagationWithBaggage(TracingProperties tracingProperties) {
            this.tracingProperties = tracingProperties;
        }

        @Bean
        @ConditionalOnEnabledTracing
        TextMapPropagator textMapPropagatorWithBaggage(OtelCurrentTraceContext otelCurrentTraceContext) {
            List<String> remoteFields = this.tracingProperties.getBaggage().getRemoteFields();
            List<String> tagFields = this.tracingProperties.getBaggage().getTagFields();
            BaggageTextMapPropagator baggagePropagator = new BaggageTextMapPropagator(remoteFields, (BaggageManager)new OtelBaggageManager((CurrentTraceContext)otelCurrentTraceContext, remoteFields, tagFields));
            return CompositeTextMapPropagator.create(this.tracingProperties.getPropagation(), (TextMapPropagator)baggagePropagator);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBooleanProperty(name={"management.tracing.baggage.correlation.enabled"}, matchIfMissing=true)
        Slf4JBaggageEventListener otelSlf4JBaggageEventListener() {
            return new Slf4JBaggageEventListener(this.tracingProperties.getBaggage().getCorrelation().getFields());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBooleanProperty(name={"management.tracing.baggage.enabled"}, havingValue=false)
    @EnableConfigurationProperties(value={TracingProperties.class})
    static class PropagationWithoutBaggage {
        PropagationWithoutBaggage() {
        }

        @Bean
        @ConditionalOnEnabledTracing
        TextMapPropagator textMapPropagator(TracingProperties properties) {
            return CompositeTextMapPropagator.create(properties.getPropagation(), null);
        }
    }
}

