/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.test.autoconfigure;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.micrometer.tracing.test.autoconfigure.AutoConfigureTracing;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;

class TracingContextCustomizerFactory
implements ContextCustomizerFactory {
    static final String AUTO_CONFIGURE_PROPERTY = "spring.test.tracing.export";

    TracingContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        AutoConfigureTracing annotation = (AutoConfigureTracing)TestContextAnnotationUtils.findMergedAnnotation(testClass, AutoConfigureTracing.class);
        return new DisableTracingExportContextCustomizer(annotation);
    }

    private static class DisableTracingExportContextCustomizer
    implements ContextCustomizer {
        private final @Nullable AutoConfigureTracing annotation;

        DisableTracingExportContextCustomizer(@Nullable AutoConfigureTracing annotation) {
            this.annotation = annotation;
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
            if (this.isTracingDisabled((Environment)context.getEnvironment())) {
                TestPropertyValues.of((String[])new String[]{"management.tracing.export.enabled=false"}).applyTo(context);
            }
        }

        private boolean isTracingDisabled(Environment environment) {
            if (this.annotation != null) {
                return !this.annotation.export();
            }
            return (Boolean)environment.getProperty(TracingContextCustomizerFactory.AUTO_CONFIGURE_PROPERTY, Boolean.class, (Object)false) == false;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisableTracingExportContextCustomizer that = (DisableTracingExportContextCustomizer)o;
            return Objects.equals(this.annotation, that.annotation);
        }

        public int hashCode() {
            return Objects.hash(this.annotation);
        }
    }
}

