/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.test.autoconfigure;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.micrometer.metrics.test.autoconfigure.AutoConfigureMetrics;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;

class MetricsContextCustomizerFactory
implements ContextCustomizerFactory {
    static final String AUTO_CONFIGURE_PROPERTY = "spring.test.metrics.export";

    MetricsContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        AutoConfigureMetrics annotation = (AutoConfigureMetrics)TestContextAnnotationUtils.findMergedAnnotation(testClass, AutoConfigureMetrics.class);
        return new DisableMetricsExportContextCustomizer(annotation);
    }

    private static class DisableMetricsExportContextCustomizer
    implements ContextCustomizer {
        private final @Nullable AutoConfigureMetrics annotation;

        DisableMetricsExportContextCustomizer(@Nullable AutoConfigureMetrics annotation) {
            this.annotation = annotation;
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
            if (this.areMetricsDisabled((Environment)context.getEnvironment())) {
                TestPropertyValues.of((String[])new String[]{"management.defaults.metrics.export.enabled=false", "management.simple.metrics.export.enabled=true"}).applyTo(context);
            }
        }

        private boolean areMetricsDisabled(Environment environment) {
            if (this.annotation != null) {
                return !this.annotation.export();
            }
            return (Boolean)environment.getProperty(MetricsContextCustomizerFactory.AUTO_CONFIGURE_PROPERTY, Boolean.class, (Object)false) == false;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisableMetricsExportContextCustomizer that = (DisableMetricsExportContextCustomizer)o;
            return Objects.equals(this.annotation, that.annotation);
        }

        public int hashCode() {
            return Objects.hash(this.annotation);
        }
    }
}

