/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import org.codehaus.plexus.util.cli.CommandLineUtils;

class RunArguments {
    private static final String[] NO_ARGS = new String[0];
    private final Deque<String> args = new LinkedList<String>();

    RunArguments(String arguments) {
        this(RunArguments.parseArgs(arguments));
    }

    RunArguments(String[] args) {
        if (args != null) {
            Arrays.stream(args).filter(Objects::nonNull).forEach(this.args::add);
        }
    }

    Deque<String> getArgs() {
        return this.args;
    }

    String[] asArray() {
        return this.args.toArray(new String[0]);
    }

    private static String[] parseArgs(String arguments) {
        if (arguments == null || arguments.trim().isEmpty()) {
            return NO_ARGS;
        }
        try {
            arguments = arguments.replace('\n', ' ').replace('\t', ' ');
            return CommandLineUtils.translateCommandline((String)arguments);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to parse arguments [" + arguments + "]", ex);
        }
    }
}

