/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ldap.autoconfigure.embedded;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFReader;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.ldap.autoconfigure.LdapAutoConfiguration;
import org.springframework.boot.ldap.autoconfigure.LdapProperties;
import org.springframework.boot.ldap.autoconfigure.embedded.EmbeddedLdapProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration(before={LdapAutoConfiguration.class})
@EnableConfigurationProperties(value={LdapProperties.class, EmbeddedLdapProperties.class})
@ConditionalOnClass(value={InMemoryDirectoryServer.class})
@Conditional(value={EmbeddedLdapCondition.class})
@ImportRuntimeHints(value={EmbeddedLdapAutoConfigurationRuntimeHints.class})
public final class EmbeddedLdapAutoConfiguration
implements DisposableBean {
    private static final String PROPERTY_SOURCE_NAME = "ldap.ports";
    private final EmbeddedLdapProperties embeddedProperties;
    private @Nullable InMemoryDirectoryServer server;

    EmbeddedLdapAutoConfiguration(EmbeddedLdapProperties embeddedProperties) {
        this.embeddedProperties = embeddedProperties;
    }

    @Bean
    InMemoryDirectoryServer directoryServer(ApplicationContext applicationContext, ObjectProvider<SslBundles> sslBundles) throws LDAPException {
        String[] baseDn = StringUtils.toStringArray(this.embeddedProperties.getBaseDn());
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(baseDn);
        String username = this.embeddedProperties.getCredential().getUsername();
        String password = this.embeddedProperties.getCredential().getPassword();
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            config.addAdditionalBindCredentials(username, password);
        }
        config.setListenerConfigs(new InMemoryListenerConfig[]{this.createListenerConfig(sslBundles)});
        this.setSchema(config);
        this.server = new InMemoryDirectoryServer(config);
        this.importLdif(this.server, applicationContext);
        this.server.startListening();
        this.setPortProperty(applicationContext, this.server.getListenPort());
        return this.server;
    }

    private InMemoryListenerConfig createListenerConfig(ObjectProvider<SslBundles> sslBundles) throws LDAPException {
        SslBundle sslBundle = this.getSslBundle((SslBundles)sslBundles.getIfAvailable());
        if (sslBundle != null) {
            SSLContext sslContext = sslBundle.createSslContext();
            SSLServerSocketFactory serverSocketFactory = sslContext.getServerSocketFactory();
            SSLSocketFactory clientSocketFactory = sslContext.getSocketFactory();
            return InMemoryListenerConfig.createLDAPSConfig((String)"LDAPS", null, (int)this.embeddedProperties.getPort(), (SSLServerSocketFactory)serverSocketFactory, (SSLSocketFactory)clientSocketFactory);
        }
        return InMemoryListenerConfig.createLDAPConfig((String)"LDAP", (int)this.embeddedProperties.getPort());
    }

    private @Nullable SslBundle getSslBundle(@Nullable SslBundles sslBundles) {
        EmbeddedLdapProperties.Ssl ssl = this.embeddedProperties.getSsl();
        if (ssl.isEnabled() && StringUtils.hasLength((String)ssl.getBundle())) {
            Assert.notNull((Object)sslBundles, (String)"SSL bundle name has been set but no SSL bundles found in context");
            return sslBundles.getBundle(ssl.getBundle());
        }
        return null;
    }

    private void setSchema(InMemoryDirectoryServerConfig config) {
        if (!this.embeddedProperties.getValidation().isEnabled()) {
            config.setSchema(null);
            return;
        }
        Resource schema = this.embeddedProperties.getValidation().getSchema();
        if (schema != null) {
            this.setSchema(config, schema);
        }
    }

    private void setSchema(InMemoryDirectoryServerConfig config, Resource resource) {
        try {
            Schema defaultSchema = Schema.getDefaultStandardSchema();
            Schema schema = Schema.getSchema((InputStream)resource.getInputStream());
            if (schema == null) {
                config.setSchema(defaultSchema);
            } else {
                config.setSchema(Schema.mergeSchemas((Schema[])new Schema[]{defaultSchema, schema}));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to load schema " + resource.getDescription(), ex);
        }
    }

    private void importLdif(InMemoryDirectoryServer server, ApplicationContext applicationContext) {
        block9: {
            String location = this.embeddedProperties.getLdif();
            if (StringUtils.hasText((String)location)) {
                try {
                    Resource resource = applicationContext.getResource(location);
                    if (!resource.exists()) break block9;
                    try (InputStream inputStream = resource.getInputStream();){
                        server.importFromLDIF(true, new LDIFReader(inputStream));
                    }
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Unable to load LDIF " + location, ex);
                }
            }
        }
    }

    private void setPortProperty(ApplicationContext context, int port) {
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)context;
            MutablePropertySources sources = configurableContext.getEnvironment().getPropertySources();
            this.getLdapPorts(sources).put("local.ldap.port", port);
        }
        if (context.getParent() != null) {
            this.setPortProperty(context.getParent(), port);
        }
    }

    private Map<String, Object> getLdapPorts(MutablePropertySources sources) {
        PropertySource propertySource = sources.get(PROPERTY_SOURCE_NAME);
        if (propertySource == null) {
            propertySource = new MapPropertySource(PROPERTY_SOURCE_NAME, new HashMap());
            sources.addFirst(propertySource);
        }
        return (Map)propertySource.getSource();
    }

    public void destroy() throws Exception {
        if (this.server != null) {
            this.server.shutDown(true);
        }
    }

    static class EmbeddedLdapAutoConfigurationRuntimeHints
    implements RuntimeHintsRegistrar {
        EmbeddedLdapAutoConfigurationRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            hints.resources().registerPatternIfPresent(classLoader, "schema.ldif", hint -> hint.includes(new String[]{"schema.ldif"}));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ContextSource.class})
    static class EmbeddedLdapContextConfiguration {
        EmbeddedLdapContextConfiguration() {
        }

        @Bean
        @DependsOn(value={"directoryServer"})
        @ConditionalOnMissingBean
        LdapContextSource ldapContextSource(Environment environment, LdapProperties properties, EmbeddedLdapProperties embeddedProperties) {
            LdapContextSource source = new LdapContextSource();
            source.setBase(properties.getBase());
            if (embeddedProperties.getCredential().isAvailable()) {
                source.setUserDn(embeddedProperties.getCredential().getUsername());
                source.setPassword(embeddedProperties.getCredential().getPassword());
            }
            source.setUrls(properties.determineUrls(environment));
            return source;
        }
    }

    static class EmbeddedLdapCondition
    extends SpringBootCondition {
        private static final Bindable<List<String>> STRING_LIST = Bindable.listOf(String.class);

        EmbeddedLdapCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Embedded LDAP", (Object[])new Object[0]);
            Environment environment = context.getEnvironment();
            if (environment != null && !((List)Binder.get((Environment)environment).bind("spring.ldap.embedded.base-dn", STRING_LIST).orElseGet(Collections::emptyList)).isEmpty()) {
                return ConditionOutcome.match((ConditionMessage)message.because("Found base-dn property"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.because("No base-dn property found"));
        }
    }
}

