/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.kotlin.serialization.autoconfigure;

import java.util.List;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonNamingStrategy;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.kotlin.serialization.autoconfigure.KotlinSerializationJsonBuilderCustomizer;
import org.springframework.boot.kotlin.serialization.autoconfigure.KotlinSerializationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;

@AutoConfiguration
@ConditionalOnClass(value={Json.class})
@EnableConfigurationProperties(value={KotlinSerializationProperties.class})
public final class KotlinSerializationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    Json kotlinSerializationJson(List<KotlinSerializationJsonBuilderCustomizer> customizers) {
        Function1 builderAction = jsonBuilder -> {
            customizers.forEach(c -> c.customize((JsonBuilder)jsonBuilder));
            return Unit.INSTANCE;
        };
        return JsonKt.Json((Json)Json.Default, (Function1)builderAction);
    }

    @Bean
    StandardKotlinSerializationJsonBuilderCustomizer standardKotlinSerializationJsonBuilderCustomizer(KotlinSerializationProperties kotlinSerializationProperties) {
        return new StandardKotlinSerializationJsonBuilderCustomizer(kotlinSerializationProperties);
    }

    static final class StandardKotlinSerializationJsonBuilderCustomizer
    implements KotlinSerializationJsonBuilderCustomizer,
    Ordered {
        private final KotlinSerializationProperties properties;

        StandardKotlinSerializationJsonBuilderCustomizer(KotlinSerializationProperties properties) {
            this.properties = properties;
        }

        public int getOrder() {
            return 0;
        }

        @Override
        public void customize(JsonBuilder jsonBuilder) {
            KotlinSerializationProperties properties = this.properties;
            PropertyMapper map = PropertyMapper.get();
            map.from(properties::getNamingStrategy).to(this.setNamingStrategy(jsonBuilder));
            map.from(properties::getPrettyPrint).to(arg_0 -> ((JsonBuilder)jsonBuilder).setPrettyPrint(arg_0));
            map.from(properties::getLenient).to(arg_0 -> ((JsonBuilder)jsonBuilder).setLenient(arg_0));
            map.from(properties::getIgnoreUnknownKeys).to(arg_0 -> ((JsonBuilder)jsonBuilder).setIgnoreUnknownKeys(arg_0));
            map.from(properties::getEncodeDefaults).to(arg_0 -> ((JsonBuilder)jsonBuilder).setEncodeDefaults(arg_0));
            map.from(properties::getExplicitNulls).to(arg_0 -> ((JsonBuilder)jsonBuilder).setExplicitNulls(arg_0));
            map.from(properties::getCoerceInputValues).to(arg_0 -> ((JsonBuilder)jsonBuilder).setCoerceInputValues(arg_0));
            map.from(properties::getAllowStructuredMapKeys).to(arg_0 -> ((JsonBuilder)jsonBuilder).setAllowStructuredMapKeys(arg_0));
            map.from(properties::getAllowSpecialFloatingPointValues).to(arg_0 -> ((JsonBuilder)jsonBuilder).setAllowSpecialFloatingPointValues(arg_0));
            map.from(properties::getClassDiscriminator).to(arg_0 -> ((JsonBuilder)jsonBuilder).setClassDiscriminator(arg_0));
            map.from(properties::getClassDiscriminatorMode).to(arg_0 -> ((JsonBuilder)jsonBuilder).setClassDiscriminatorMode(arg_0));
            map.from(properties::getDecodeEnumsCaseInsensitive).to(arg_0 -> ((JsonBuilder)jsonBuilder).setDecodeEnumsCaseInsensitive(arg_0));
            map.from(properties::getUseAlternativeNames).to(arg_0 -> ((JsonBuilder)jsonBuilder).setUseAlternativeNames(arg_0));
            map.from(properties::getAllowTrailingComma).to(arg_0 -> ((JsonBuilder)jsonBuilder).setAllowTrailingComma(arg_0));
            map.from(properties::getAllowComments).to(arg_0 -> ((JsonBuilder)jsonBuilder).setAllowComments(arg_0));
        }

        private Consumer<KotlinSerializationProperties.JsonNamingStrategy> setNamingStrategy(JsonBuilder builder) {
            return strategy -> {
                JsonNamingStrategy namingStrategy = switch (strategy) {
                    default -> throw new IncompatibleClassChangeError();
                    case KotlinSerializationProperties.JsonNamingStrategy.SNAKE_CASE -> JsonNamingStrategy.Builtins.getSnakeCase();
                    case KotlinSerializationProperties.JsonNamingStrategy.KEBAB_CASE -> JsonNamingStrategy.Builtins.getKebabCase();
                };
                builder.setNamingStrategy(namingStrategy);
            };
        }
    }
}

