/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.kafka.autoconfigure;

import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.source.MutuallyExclusiveConfigurationPropertiesException;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.core.io.Resource;
import org.springframework.kafka.security.jaas.KafkaJaasLoginModuleInitializer;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="spring.kafka")
public class KafkaProperties {
    private List<String> bootstrapServers = new ArrayList<String>(Collections.singletonList("localhost:9092"));
    private @Nullable String clientId;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Consumer consumer = new Consumer();
    private final Producer producer = new Producer();
    private final Admin admin = new Admin();
    private final Streams streams = new Streams();
    private final Listener listener = new Listener();
    private final Ssl ssl = new Ssl();
    private final Jaas jaas = new Jaas();
    private final Template template = new Template();
    private final Security security = new Security();
    private final Retry retry = new Retry();

    public List<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(List<String> bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public @Nullable String getClientId() {
        return this.clientId;
    }

    public void setClientId(@Nullable String clientId) {
        this.clientId = clientId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public Producer getProducer() {
        return this.producer;
    }

    public Listener getListener() {
        return this.listener;
    }

    public Admin getAdmin() {
        return this.admin;
    }

    public Streams getStreams() {
        return this.streams;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public Jaas getJaas() {
        return this.jaas;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Security getSecurity() {
        return this.security;
    }

    public Retry getRetry() {
        return this.retry;
    }

    private Map<String, Object> buildCommonProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.bootstrapServers != null) {
            properties.put("bootstrap.servers", this.bootstrapServers);
        }
        if (this.clientId != null) {
            properties.put("client.id", this.clientId);
        }
        properties.putAll(this.ssl.buildProperties());
        properties.putAll(this.security.buildProperties());
        if (!CollectionUtils.isEmpty(this.properties)) {
            properties.putAll(this.properties);
        }
        return properties;
    }

    public Map<String, Object> buildConsumerProperties() {
        Map<String, Object> properties = this.buildCommonProperties();
        properties.putAll(this.consumer.buildProperties());
        return properties;
    }

    public Map<String, Object> buildProducerProperties() {
        Map<String, Object> properties = this.buildCommonProperties();
        properties.putAll(this.producer.buildProperties());
        return properties;
    }

    public Map<String, Object> buildAdminProperties() {
        Map<String, Object> properties = this.buildCommonProperties();
        properties.putAll(this.admin.buildProperties());
        return properties;
    }

    public Map<String, Object> buildStreamsProperties() {
        Map<String, Object> properties = this.buildCommonProperties();
        properties.putAll(this.streams.buildProperties());
        return properties;
    }

    public static class Consumer {
        private final Ssl ssl = new Ssl();
        private final Security security = new Security();
        private @Nullable Duration autoCommitInterval;
        private @Nullable String autoOffsetReset;
        private @Nullable List<String> bootstrapServers;
        private @Nullable String clientId;
        private @Nullable Boolean enableAutoCommit;
        private @Nullable Duration fetchMaxWait;
        private @Nullable DataSize fetchMinSize;
        private @Nullable String groupId;
        private @Nullable Duration heartbeatInterval;
        private IsolationLevel isolationLevel = IsolationLevel.READ_UNCOMMITTED;
        private Class<?> keyDeserializer = StringDeserializer.class;
        private Class<?> valueDeserializer = StringDeserializer.class;
        private @Nullable Integer maxPollRecords;
        private @Nullable Duration maxPollInterval;
        private final Map<String, String> properties = new HashMap<String, String>();

        public Ssl getSsl() {
            return this.ssl;
        }

        public Security getSecurity() {
            return this.security;
        }

        public @Nullable Duration getAutoCommitInterval() {
            return this.autoCommitInterval;
        }

        public void setAutoCommitInterval(@Nullable Duration autoCommitInterval) {
            this.autoCommitInterval = autoCommitInterval;
        }

        public @Nullable String getAutoOffsetReset() {
            return this.autoOffsetReset;
        }

        public void setAutoOffsetReset(@Nullable String autoOffsetReset) {
            this.autoOffsetReset = autoOffsetReset;
        }

        public @Nullable List<String> getBootstrapServers() {
            return this.bootstrapServers;
        }

        public void setBootstrapServers(@Nullable List<String> bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        public @Nullable String getClientId() {
            return this.clientId;
        }

        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        public @Nullable Boolean getEnableAutoCommit() {
            return this.enableAutoCommit;
        }

        public void setEnableAutoCommit(@Nullable Boolean enableAutoCommit) {
            this.enableAutoCommit = enableAutoCommit;
        }

        public @Nullable Duration getFetchMaxWait() {
            return this.fetchMaxWait;
        }

        public void setFetchMaxWait(@Nullable Duration fetchMaxWait) {
            this.fetchMaxWait = fetchMaxWait;
        }

        public @Nullable DataSize getFetchMinSize() {
            return this.fetchMinSize;
        }

        public void setFetchMinSize(@Nullable DataSize fetchMinSize) {
            this.fetchMinSize = fetchMinSize;
        }

        public @Nullable String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(@Nullable String groupId) {
            this.groupId = groupId;
        }

        public @Nullable Duration getHeartbeatInterval() {
            return this.heartbeatInterval;
        }

        public void setHeartbeatInterval(@Nullable Duration heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
        }

        public IsolationLevel getIsolationLevel() {
            return this.isolationLevel;
        }

        public void setIsolationLevel(IsolationLevel isolationLevel) {
            this.isolationLevel = isolationLevel;
        }

        public Class<?> getKeyDeserializer() {
            return this.keyDeserializer;
        }

        public void setKeyDeserializer(Class<?> keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
        }

        public Class<?> getValueDeserializer() {
            return this.valueDeserializer;
        }

        public void setValueDeserializer(Class<?> valueDeserializer) {
            this.valueDeserializer = valueDeserializer;
        }

        public @Nullable Integer getMaxPollRecords() {
            return this.maxPollRecords;
        }

        public void setMaxPollRecords(@Nullable Integer maxPollRecords) {
            this.maxPollRecords = maxPollRecords;
        }

        public @Nullable Duration getMaxPollInterval() {
            return this.maxPollInterval;
        }

        public void setMaxPollInterval(@Nullable Duration maxPollInterval) {
            this.maxPollInterval = maxPollInterval;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Map<String, Object> buildProperties() {
            Properties properties = new Properties();
            PropertyMapper map = PropertyMapper.get();
            map.from(this::getAutoCommitInterval).asInt(Duration::toMillis).to(properties.in("auto.commit.interval.ms"));
            map.from(this::getAutoOffsetReset).to(properties.in("auto.offset.reset"));
            map.from(this::getBootstrapServers).to(properties.in("bootstrap.servers"));
            map.from(this::getClientId).to(properties.in("client.id"));
            map.from(this::getEnableAutoCommit).to(properties.in("enable.auto.commit"));
            map.from(this::getFetchMaxWait).asInt(Duration::toMillis).to(properties.in("fetch.max.wait.ms"));
            map.from(this::getFetchMinSize).asInt(DataSize::toBytes).to(properties.in("fetch.min.bytes"));
            map.from(this::getGroupId).to(properties.in("group.id"));
            map.from(this::getHeartbeatInterval).asInt(Duration::toMillis).to(properties.in("heartbeat.interval.ms"));
            map.from(() -> this.getIsolationLevel().name().toLowerCase(Locale.ROOT)).to(properties.in("isolation.level"));
            map.from(this::getKeyDeserializer).to(properties.in("key.deserializer"));
            map.from(this::getValueDeserializer).to(properties.in("value.deserializer"));
            map.from(this::getMaxPollRecords).to(properties.in("max.poll.records"));
            map.from(this::getMaxPollInterval).asInt(Duration::toMillis).to(properties.in("max.poll.interval.ms"));
            return properties.with(this.ssl, this.security, this.properties);
        }
    }

    public static class Producer {
        private final Ssl ssl = new Ssl();
        private final Security security = new Security();
        private @Nullable String acks;
        private @Nullable DataSize batchSize;
        private @Nullable List<String> bootstrapServers;
        private @Nullable DataSize bufferMemory;
        private @Nullable String clientId;
        private @Nullable String compressionType;
        private Class<?> keySerializer = StringSerializer.class;
        private Class<?> valueSerializer = StringSerializer.class;
        private @Nullable Integer retries;
        private @Nullable String transactionIdPrefix;
        private final Map<String, String> properties = new HashMap<String, String>();

        public Ssl getSsl() {
            return this.ssl;
        }

        public Security getSecurity() {
            return this.security;
        }

        public @Nullable String getAcks() {
            return this.acks;
        }

        public void setAcks(@Nullable String acks) {
            this.acks = acks;
        }

        public @Nullable DataSize getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(@Nullable DataSize batchSize) {
            this.batchSize = batchSize;
        }

        public @Nullable List<String> getBootstrapServers() {
            return this.bootstrapServers;
        }

        public void setBootstrapServers(@Nullable List<String> bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        public @Nullable DataSize getBufferMemory() {
            return this.bufferMemory;
        }

        public void setBufferMemory(@Nullable DataSize bufferMemory) {
            this.bufferMemory = bufferMemory;
        }

        public @Nullable String getClientId() {
            return this.clientId;
        }

        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        public @Nullable String getCompressionType() {
            return this.compressionType;
        }

        public void setCompressionType(@Nullable String compressionType) {
            this.compressionType = compressionType;
        }

        public Class<?> getKeySerializer() {
            return this.keySerializer;
        }

        public void setKeySerializer(Class<?> keySerializer) {
            this.keySerializer = keySerializer;
        }

        public Class<?> getValueSerializer() {
            return this.valueSerializer;
        }

        public void setValueSerializer(Class<?> valueSerializer) {
            this.valueSerializer = valueSerializer;
        }

        public @Nullable Integer getRetries() {
            return this.retries;
        }

        public void setRetries(@Nullable Integer retries) {
            this.retries = retries;
        }

        public @Nullable String getTransactionIdPrefix() {
            return this.transactionIdPrefix;
        }

        public void setTransactionIdPrefix(@Nullable String transactionIdPrefix) {
            this.transactionIdPrefix = transactionIdPrefix;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Map<String, Object> buildProperties() {
            Properties properties = new Properties();
            PropertyMapper map = PropertyMapper.get();
            map.from(this::getAcks).to(properties.in("acks"));
            map.from(this::getBatchSize).asInt(DataSize::toBytes).to(properties.in("batch.size"));
            map.from(this::getBootstrapServers).to(properties.in("bootstrap.servers"));
            map.from(this::getBufferMemory).as(DataSize::toBytes).to(properties.in("buffer.memory"));
            map.from(this::getClientId).to(properties.in("client.id"));
            map.from(this::getCompressionType).to(properties.in("compression.type"));
            map.from(this::getKeySerializer).to(properties.in("key.serializer"));
            map.from(this::getRetries).to(properties.in("retries"));
            map.from(this::getValueSerializer).to(properties.in("value.serializer"));
            return properties.with(this.ssl, this.security, this.properties);
        }
    }

    public static class Admin {
        private final Ssl ssl = new Ssl();
        private final Security security = new Security();
        private @Nullable String clientId;
        private final Map<String, String> properties = new HashMap<String, String>();
        private @Nullable Duration closeTimeout;
        private @Nullable Duration operationTimeout;
        private boolean failFast;
        private boolean modifyTopicConfigs;
        private boolean autoCreate = true;

        public Ssl getSsl() {
            return this.ssl;
        }

        public Security getSecurity() {
            return this.security;
        }

        public @Nullable String getClientId() {
            return this.clientId;
        }

        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        public @Nullable Duration getCloseTimeout() {
            return this.closeTimeout;
        }

        public void setCloseTimeout(@Nullable Duration closeTimeout) {
            this.closeTimeout = closeTimeout;
        }

        public @Nullable Duration getOperationTimeout() {
            return this.operationTimeout;
        }

        public void setOperationTimeout(@Nullable Duration operationTimeout) {
            this.operationTimeout = operationTimeout;
        }

        public boolean isFailFast() {
            return this.failFast;
        }

        public void setFailFast(boolean failFast) {
            this.failFast = failFast;
        }

        public boolean isModifyTopicConfigs() {
            return this.modifyTopicConfigs;
        }

        public void setModifyTopicConfigs(boolean modifyTopicConfigs) {
            this.modifyTopicConfigs = modifyTopicConfigs;
        }

        public boolean isAutoCreate() {
            return this.autoCreate;
        }

        public void setAutoCreate(boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Map<String, Object> buildProperties() {
            Properties properties = new Properties();
            PropertyMapper map = PropertyMapper.get();
            map.from(this::getClientId).to(properties.in("client.id"));
            return properties.with(this.ssl, this.security, this.properties);
        }
    }

    public static class Streams {
        private final Ssl ssl = new Ssl();
        private final Security security = new Security();
        private final Cleanup cleanup = new Cleanup();
        private @Nullable String applicationId;
        private boolean autoStartup = true;
        private @Nullable List<String> bootstrapServers;
        private @Nullable DataSize stateStoreCacheMaxSize;
        private @Nullable String clientId;
        private @Nullable Integer replicationFactor;
        private @Nullable String stateDir;
        private final Map<String, String> properties = new HashMap<String, String>();

        public Ssl getSsl() {
            return this.ssl;
        }

        public Security getSecurity() {
            return this.security;
        }

        public Cleanup getCleanup() {
            return this.cleanup;
        }

        public @Nullable String getApplicationId() {
            return this.applicationId;
        }

        public void setApplicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
        }

        public boolean isAutoStartup() {
            return this.autoStartup;
        }

        public void setAutoStartup(boolean autoStartup) {
            this.autoStartup = autoStartup;
        }

        public @Nullable List<String> getBootstrapServers() {
            return this.bootstrapServers;
        }

        public void setBootstrapServers(@Nullable List<String> bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        public @Nullable DataSize getStateStoreCacheMaxSize() {
            return this.stateStoreCacheMaxSize;
        }

        public void setStateStoreCacheMaxSize(@Nullable DataSize stateStoreCacheMaxSize) {
            this.stateStoreCacheMaxSize = stateStoreCacheMaxSize;
        }

        public @Nullable String getClientId() {
            return this.clientId;
        }

        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        public @Nullable Integer getReplicationFactor() {
            return this.replicationFactor;
        }

        public void setReplicationFactor(@Nullable Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
        }

        public @Nullable String getStateDir() {
            return this.stateDir;
        }

        public void setStateDir(@Nullable String stateDir) {
            this.stateDir = stateDir;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Map<String, Object> buildProperties() {
            Properties properties = new Properties();
            PropertyMapper map = PropertyMapper.get();
            map.from(this::getApplicationId).to(properties.in("application.id"));
            map.from(this::getBootstrapServers).to(properties.in("bootstrap.servers"));
            map.from(this::getStateStoreCacheMaxSize).asInt(DataSize::toBytes).to(properties.in("statestore.cache.max.bytes"));
            map.from(this::getClientId).to(properties.in("client.id"));
            map.from(this::getReplicationFactor).to(properties.in("replication.factor"));
            map.from(this::getStateDir).to(properties.in("state.dir"));
            return properties.with(this.ssl, this.security, this.properties);
        }
    }

    public static class Listener {
        private Type type = Type.SINGLE;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable ContainerProperties.AckMode ackMode;
        private @Nullable Boolean asyncAcks;
        private @Nullable String clientId;
        private @Nullable Integer concurrency;
        private @Nullable Duration pollTimeout;
        private @Nullable Float noPollThreshold;
        private @Nullable Integer ackCount;
        private @Nullable Duration ackTime;
        private Duration idleBetweenPolls = Duration.ZERO;
        private @Nullable Duration idleEventInterval;
        private @Nullable Duration idlePartitionEventInterval;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private @Nullable Duration monitorInterval;
        private @Nullable Boolean logContainerConfig;
        private boolean missingTopicsFatal = false;
        private boolean immediateStop = false;
        private boolean autoStartup = true;
        private @Nullable Boolean changeConsumerThreadName;
        private boolean observationEnabled;
        private @Nullable Duration authExceptionRetryInterval;

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable ContainerProperties.AckMode getAckMode() {
            return this.ackMode;
        }

        public void setAckMode(// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable ContainerProperties.AckMode ackMode) {
            this.ackMode = ackMode;
        }

        public @Nullable Boolean getAsyncAcks() {
            return this.asyncAcks;
        }

        public void setAsyncAcks(@Nullable Boolean asyncAcks) {
            this.asyncAcks = asyncAcks;
        }

        public @Nullable String getClientId() {
            return this.clientId;
        }

        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        public @Nullable Integer getConcurrency() {
            return this.concurrency;
        }

        public void setConcurrency(@Nullable Integer concurrency) {
            this.concurrency = concurrency;
        }

        public @Nullable Duration getPollTimeout() {
            return this.pollTimeout;
        }

        public void setPollTimeout(@Nullable Duration pollTimeout) {
            this.pollTimeout = pollTimeout;
        }

        public @Nullable Float getNoPollThreshold() {
            return this.noPollThreshold;
        }

        public void setNoPollThreshold(@Nullable Float noPollThreshold) {
            this.noPollThreshold = noPollThreshold;
        }

        public @Nullable Integer getAckCount() {
            return this.ackCount;
        }

        public void setAckCount(@Nullable Integer ackCount) {
            this.ackCount = ackCount;
        }

        public @Nullable Duration getAckTime() {
            return this.ackTime;
        }

        public void setAckTime(@Nullable Duration ackTime) {
            this.ackTime = ackTime;
        }

        public Duration getIdleBetweenPolls() {
            return this.idleBetweenPolls;
        }

        public void setIdleBetweenPolls(Duration idleBetweenPolls) {
            this.idleBetweenPolls = idleBetweenPolls;
        }

        public @Nullable Duration getIdleEventInterval() {
            return this.idleEventInterval;
        }

        public void setIdleEventInterval(@Nullable Duration idleEventInterval) {
            this.idleEventInterval = idleEventInterval;
        }

        public @Nullable Duration getIdlePartitionEventInterval() {
            return this.idlePartitionEventInterval;
        }

        public void setIdlePartitionEventInterval(@Nullable Duration idlePartitionEventInterval) {
            this.idlePartitionEventInterval = idlePartitionEventInterval;
        }

        public @Nullable Duration getMonitorInterval() {
            return this.monitorInterval;
        }

        public void setMonitorInterval(@Nullable Duration monitorInterval) {
            this.monitorInterval = monitorInterval;
        }

        public @Nullable Boolean getLogContainerConfig() {
            return this.logContainerConfig;
        }

        public void setLogContainerConfig(@Nullable Boolean logContainerConfig) {
            this.logContainerConfig = logContainerConfig;
        }

        public boolean isMissingTopicsFatal() {
            return this.missingTopicsFatal;
        }

        public void setMissingTopicsFatal(boolean missingTopicsFatal) {
            this.missingTopicsFatal = missingTopicsFatal;
        }

        public boolean isImmediateStop() {
            return this.immediateStop;
        }

        public void setImmediateStop(boolean immediateStop) {
            this.immediateStop = immediateStop;
        }

        public boolean isAutoStartup() {
            return this.autoStartup;
        }

        public void setAutoStartup(boolean autoStartup) {
            this.autoStartup = autoStartup;
        }

        public @Nullable Boolean getChangeConsumerThreadName() {
            return this.changeConsumerThreadName;
        }

        public void setChangeConsumerThreadName(@Nullable Boolean changeConsumerThreadName) {
            this.changeConsumerThreadName = changeConsumerThreadName;
        }

        public boolean isObservationEnabled() {
            return this.observationEnabled;
        }

        public void setObservationEnabled(boolean observationEnabled) {
            this.observationEnabled = observationEnabled;
        }

        public @Nullable Duration getAuthExceptionRetryInterval() {
            return this.authExceptionRetryInterval;
        }

        public void setAuthExceptionRetryInterval(@Nullable Duration authExceptionRetryInterval) {
            this.authExceptionRetryInterval = authExceptionRetryInterval;
        }

        public static enum Type {
            SINGLE,
            BATCH;

        }
    }

    public static class Ssl {
        private @Nullable String bundle;
        private @Nullable String keyPassword;
        private @Nullable String keyStoreCertificateChain;
        private @Nullable String keyStoreKey;
        private @Nullable Resource keyStoreLocation;
        private @Nullable String keyStorePassword;
        private @Nullable String keyStoreType;
        private @Nullable String trustStoreCertificates;
        private @Nullable Resource trustStoreLocation;
        private @Nullable String trustStorePassword;
        private @Nullable String trustStoreType;
        private @Nullable String protocol;

        public @Nullable String getBundle() {
            return this.bundle;
        }

        public void setBundle(@Nullable String bundle) {
            this.bundle = bundle;
        }

        public @Nullable String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(@Nullable String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public @Nullable String getKeyStoreCertificateChain() {
            return this.keyStoreCertificateChain;
        }

        public void setKeyStoreCertificateChain(@Nullable String keyStoreCertificateChain) {
            this.keyStoreCertificateChain = keyStoreCertificateChain;
        }

        public @Nullable String getKeyStoreKey() {
            return this.keyStoreKey;
        }

        public void setKeyStoreKey(@Nullable String keyStoreKey) {
            this.keyStoreKey = keyStoreKey;
        }

        public @Nullable Resource getKeyStoreLocation() {
            return this.keyStoreLocation;
        }

        public void setKeyStoreLocation(@Nullable Resource keyStoreLocation) {
            this.keyStoreLocation = keyStoreLocation;
        }

        public @Nullable String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(@Nullable String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public @Nullable String getKeyStoreType() {
            return this.keyStoreType;
        }

        public void setKeyStoreType(@Nullable String keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        public @Nullable String getTrustStoreCertificates() {
            return this.trustStoreCertificates;
        }

        public void setTrustStoreCertificates(@Nullable String trustStoreCertificates) {
            this.trustStoreCertificates = trustStoreCertificates;
        }

        public @Nullable Resource getTrustStoreLocation() {
            return this.trustStoreLocation;
        }

        public void setTrustStoreLocation(@Nullable Resource trustStoreLocation) {
            this.trustStoreLocation = trustStoreLocation;
        }

        public @Nullable String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(@Nullable String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        public @Nullable String getTrustStoreType() {
            return this.trustStoreType;
        }

        public void setTrustStoreType(@Nullable String trustStoreType) {
            this.trustStoreType = trustStoreType;
        }

        public @Nullable String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(@Nullable String protocol) {
            this.protocol = protocol;
        }

        public Map<String, Object> buildProperties() {
            this.validate();
            String bundleName = this.getBundle();
            Properties properties = new Properties();
            if (StringUtils.hasText((String)bundleName)) {
                return properties;
            }
            PropertyMapper map = PropertyMapper.get();
            map.from(this::getKeyPassword).to(properties.in("ssl.key.password"));
            map.from(this::getKeyStoreCertificateChain).to(properties.in("ssl.keystore.certificate.chain"));
            map.from(this::getKeyStoreKey).to(properties.in("ssl.keystore.key"));
            map.from(this::getKeyStoreLocation).as(this::resourceToPath).to(properties.in("ssl.keystore.location"));
            map.from(this::getKeyStorePassword).to(properties.in("ssl.keystore.password"));
            map.from(this::getKeyStoreType).to(properties.in("ssl.keystore.type"));
            map.from(this::getTrustStoreCertificates).to(properties.in("ssl.truststore.certificates"));
            map.from(this::getTrustStoreLocation).as(this::resourceToPath).to(properties.in("ssl.truststore.location"));
            map.from(this::getTrustStorePassword).to(properties.in("ssl.truststore.password"));
            map.from(this::getTrustStoreType).to(properties.in("ssl.truststore.type"));
            map.from(this::getProtocol).to(properties.in("ssl.protocol"));
            return properties;
        }

        private void validate() {
            MutuallyExclusiveConfigurationPropertiesException.throwIfMultipleMatchingValuesIn(entries -> {
                entries.put("spring.kafka.ssl.key-store-key", this.getKeyStoreKey());
                entries.put("spring.kafka.ssl.key-store-location", this.getKeyStoreLocation());
            }, this::hasValue);
            MutuallyExclusiveConfigurationPropertiesException.throwIfMultipleMatchingValuesIn(entries -> {
                entries.put("spring.kafka.ssl.trust-store-certificates", this.getTrustStoreCertificates());
                entries.put("spring.kafka.ssl.trust-store-location", this.getTrustStoreLocation());
            }, this::hasValue);
            MutuallyExclusiveConfigurationPropertiesException.throwIfMultipleMatchingValuesIn(entries -> {
                entries.put("spring.kafka.ssl.bundle", this.getBundle());
                entries.put("spring.kafka.ssl.key-store-key", this.getKeyStoreKey());
            }, this::hasValue);
            MutuallyExclusiveConfigurationPropertiesException.throwIfMultipleMatchingValuesIn(entries -> {
                entries.put("spring.kafka.ssl.bundle", this.getBundle());
                entries.put("spring.kafka.ssl.key-store-location", this.getKeyStoreLocation());
            }, this::hasValue);
            MutuallyExclusiveConfigurationPropertiesException.throwIfMultipleMatchingValuesIn(entries -> {
                entries.put("spring.kafka.ssl.bundle", this.getBundle());
                entries.put("spring.kafka.ssl.trust-store-certificates", this.getTrustStoreCertificates());
            }, this::hasValue);
            MutuallyExclusiveConfigurationPropertiesException.throwIfMultipleMatchingValuesIn(entries -> {
                entries.put("spring.kafka.ssl.bundle", this.getBundle());
                entries.put("spring.kafka.ssl.trust-store-location", this.getTrustStoreLocation());
            }, this::hasValue);
        }

        private boolean hasValue(@Nullable Object value) {
            boolean bl;
            if (value instanceof String) {
                String string = (String)value;
                bl = StringUtils.hasText((String)string);
            } else {
                bl = value != null;
            }
            return bl;
        }

        private String resourceToPath(Resource resource) {
            try {
                return resource.getFile().getAbsolutePath();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Resource '" + String.valueOf(resource) + "' must be on a file system", ex);
            }
        }
    }

    public static class Jaas {
        private boolean enabled;
        private String loginModule = "com.sun.security.auth.module.Krb5LoginModule";
        private KafkaJaasLoginModuleInitializer.ControlFlag controlFlag = KafkaJaasLoginModuleInitializer.ControlFlag.REQUIRED;
        private final Map<String, String> options = new HashMap<String, String>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getLoginModule() {
            return this.loginModule;
        }

        public void setLoginModule(String loginModule) {
            this.loginModule = loginModule;
        }

        public KafkaJaasLoginModuleInitializer.ControlFlag getControlFlag() {
            return this.controlFlag;
        }

        public void setControlFlag(KafkaJaasLoginModuleInitializer.ControlFlag controlFlag) {
            this.controlFlag = controlFlag;
        }

        public Map<String, String> getOptions() {
            return this.options;
        }

        public void setOptions(Map<String, String> options) {
            if (options != null) {
                this.options.putAll(options);
            }
        }
    }

    public static class Template {
        private @Nullable String defaultTopic;
        private @Nullable String transactionIdPrefix;
        private boolean observationEnabled;

        public @Nullable String getDefaultTopic() {
            return this.defaultTopic;
        }

        public void setDefaultTopic(@Nullable String defaultTopic) {
            this.defaultTopic = defaultTopic;
        }

        public @Nullable String getTransactionIdPrefix() {
            return this.transactionIdPrefix;
        }

        public void setTransactionIdPrefix(@Nullable String transactionIdPrefix) {
            this.transactionIdPrefix = transactionIdPrefix;
        }

        public boolean isObservationEnabled() {
            return this.observationEnabled;
        }

        public void setObservationEnabled(boolean observationEnabled) {
            this.observationEnabled = observationEnabled;
        }
    }

    public static class Security {
        private @Nullable String protocol;

        public @Nullable String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(@Nullable String protocol) {
            this.protocol = protocol;
        }

        public Map<String, Object> buildProperties() {
            Properties properties = new Properties();
            PropertyMapper map = PropertyMapper.get();
            map.from(this::getProtocol).to(properties.in("security.protocol"));
            return properties;
        }
    }

    public static class Retry {
        private final Topic topic = new Topic();

        public Topic getTopic() {
            return this.topic;
        }

        public static class Topic {
            private boolean enabled;
            private int attempts = 3;
            private final Backoff backoff = new Backoff();

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public int getAttempts() {
                return this.attempts;
            }

            public void setAttempts(int attempts) {
                this.attempts = attempts;
            }

            public Backoff getBackoff() {
                return this.backoff;
            }

            public static class Backoff {
                private Duration delay = Duration.ofSeconds(1L);
                private double multiplier = 1.0;
                private Duration maxDelay = Duration.ofSeconds(30L);
                private Duration jitter = Duration.ZERO;

                public Duration getDelay() {
                    return this.delay;
                }

                public void setDelay(Duration delay) {
                    this.delay = delay;
                }

                public double getMultiplier() {
                    return this.multiplier;
                }

                public void setMultiplier(double multiplier) {
                    this.multiplier = multiplier;
                }

                public Duration getMaxDelay() {
                    return this.maxDelay;
                }

                public void setMaxDelay(Duration maxDelay) {
                    this.maxDelay = maxDelay;
                }

                public Duration getJitter() {
                    return this.jitter;
                }

                public void setJitter(Duration jitter) {
                    this.jitter = jitter;
                }
            }
        }
    }

    private static final class Properties
    extends HashMap<String, Object> {
        private Properties() {
        }

        <V> java.util.function.Consumer<V> in(String key) {
            return value -> this.put(key, value);
        }

        Properties with(Ssl ssl, Security security, Map<String, String> properties) {
            this.putAll(ssl.buildProperties());
            this.putAll(security.buildProperties());
            this.putAll(properties);
            return this;
        }
    }

    public static enum IsolationLevel {
        READ_UNCOMMITTED(0),
        READ_COMMITTED(1);

        private final byte id;

        private IsolationLevel(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }

    public static class Cleanup {
        private boolean onStartup = false;
        private boolean onShutdown = false;

        public boolean isOnStartup() {
            return this.onStartup;
        }

        public void setOnStartup(boolean onStartup) {
            this.onStartup = onStartup;
        }

        public boolean isOnShutdown() {
            return this.onShutdown;
        }

        public void setOnShutdown(boolean onShutdown) {
            this.onShutdown = onShutdown;
        }
    }
}

