/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jpa.autoconfigure;

import jakarta.persistence.EntityManagerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingFilterBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jpa.EntityManagerFactoryBuilder;
import org.springframework.boot.jpa.autoconfigure.EntityManagerFactoryBuilderCustomizer;
import org.springframework.boot.jpa.autoconfigure.JpaProperties;
import org.springframework.boot.transaction.autoconfigure.TransactionManagerCustomizers;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.ManagedClassNameFilter;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypesScanner;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewFilter;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={JpaProperties.class})
public abstract class JpaBaseConfiguration {
    private final DataSource dataSource;
    private final JpaProperties properties;
    private final JtaTransactionManager jtaTransactionManager;

    protected JpaBaseConfiguration(DataSource dataSource, JpaProperties properties, ObjectProvider<JtaTransactionManager> jtaTransactionManager) {
        this.dataSource = dataSource;
        this.properties = properties;
        this.jtaTransactionManager = (JtaTransactionManager)jtaTransactionManager.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean(value={TransactionManager.class})
    public PlatformTransactionManager transactionManager(ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((TransactionManager)transactionManager));
        return transactionManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public JpaVendorAdapter jpaVendorAdapter() {
        AbstractJpaVendorAdapter adapter = this.createJpaVendorAdapter();
        adapter.setShowSql(this.properties.isShowSql());
        if (this.properties.getDatabase() != null) {
            adapter.setDatabase(this.properties.getDatabase());
        }
        if (this.properties.getDatabasePlatform() != null) {
            adapter.setDatabasePlatform(this.properties.getDatabasePlatform());
        }
        adapter.setGenerateDdl(this.properties.isGenerateDdl());
        return adapter;
    }

    @Bean
    @ConditionalOnMissingBean
    public EntityManagerFactoryBuilder entityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, ObjectProvider<PersistenceUnitManager> persistenceUnitManager, ObjectProvider<EntityManagerFactoryBuilderCustomizer> customizers) {
        EntityManagerFactoryBuilder builder = new EntityManagerFactoryBuilder(jpaVendorAdapter, this::buildJpaProperties, (PersistenceUnitManager)persistenceUnitManager.getIfAvailable());
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    private Map<String, ?> buildJpaProperties(DataSource dataSource) {
        HashMap<String, String> properties = new HashMap<String, String>(this.properties.getProperties());
        Map<String, Object> vendorProperties = this.getVendorProperties(dataSource);
        this.customizeVendorProperties(vendorProperties);
        properties.putAll(vendorProperties);
        return properties;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={LocalContainerEntityManagerFactoryBean.class, EntityManagerFactory.class})
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder factoryBuilder, PersistenceManagedTypes persistenceManagedTypes) {
        return factoryBuilder.dataSource(this.dataSource).managedTypes(persistenceManagedTypes).mappingResources(this.getMappingResources()).jta(this.isJta()).build();
    }

    protected abstract AbstractJpaVendorAdapter createJpaVendorAdapter();

    protected abstract Map<String, Object> getVendorProperties(DataSource var1);

    protected void customizeVendorProperties(Map<String, Object> vendorProperties) {
    }

    private String[] getMappingResources() {
        List<String> mappingResources = this.properties.getMappingResources();
        return !ObjectUtils.isEmpty(mappingResources) ? StringUtils.toStringArray(mappingResources) : null;
    }

    protected JtaTransactionManager getJtaTransactionManager() {
        return this.jtaTransactionManager;
    }

    protected final boolean isJta() {
        return this.jtaTransactionManager != null;
    }

    protected final JpaProperties getProperties() {
        return this.properties;
    }

    protected final DataSource getDataSource() {
        return this.dataSource;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    @ConditionalOnMissingBean(value={OpenEntityManagerInViewInterceptor.class, OpenEntityManagerInViewFilter.class})
    @ConditionalOnMissingFilterBean(value={OpenEntityManagerInViewFilter.class})
    @ConditionalOnBooleanProperty(name={"spring.jpa.open-in-view"}, matchIfMissing=true)
    protected static class JpaWebConfiguration {
        private static final Log logger = LogFactory.getLog(JpaWebConfiguration.class);
        private final JpaProperties jpaProperties;

        protected JpaWebConfiguration(JpaProperties jpaProperties) {
            this.jpaProperties = jpaProperties;
        }

        @Bean
        public OpenEntityManagerInViewInterceptor openEntityManagerInViewInterceptor() {
            if (this.jpaProperties.getOpenInView() == null) {
                logger.warn((Object)"spring.jpa.open-in-view is enabled by default. Therefore, database queries may be performed during view rendering. Explicitly configure spring.jpa.open-in-view to disable this warning");
            }
            return new OpenEntityManagerInViewInterceptor();
        }

        @Bean
        public WebMvcConfigurer openEntityManagerInViewInterceptorConfigurer(final OpenEntityManagerInViewInterceptor interceptor) {
            return new WebMvcConfigurer(){
                final /* synthetic */ JpaWebConfiguration this$0;
                {
                    this.this$0 = this$0;
                }

                public void addInterceptors(InterceptorRegistry registry) {
                    registry.addWebRequestInterceptor((WebRequestInterceptor)interceptor);
                }
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={LocalContainerEntityManagerFactoryBean.class, EntityManagerFactory.class})
    static class PersistenceManagedTypesConfiguration {
        PersistenceManagedTypesConfiguration() {
        }

        @Bean
        @Primary
        @ConditionalOnMissingBean
        static PersistenceManagedTypes persistenceManagedTypes(BeanFactory beanFactory, ResourceLoader resourceLoader, ObjectProvider<ManagedClassNameFilter> managedClassNameFilter) {
            String[] packagesToScan = PersistenceManagedTypesConfiguration.getPackagesToScan(beanFactory);
            return new PersistenceManagedTypesScanner(resourceLoader, (ManagedClassNameFilter)managedClassNameFilter.getIfAvailable()).scan(packagesToScan);
        }

        private static String[] getPackagesToScan(BeanFactory beanFactory) {
            List packages = EntityScanPackages.get((BeanFactory)beanFactory).getPackageNames();
            if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)beanFactory)) {
                packages = AutoConfigurationPackages.get((BeanFactory)beanFactory);
            }
            return StringUtils.toStringArray((Collection)packages);
        }
    }
}

