/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jooq.autoconfigure;

import java.sql.SQLException;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jooq.ExecuteContext;
import org.jooq.SQLDialect;
import org.springframework.boot.jooq.autoconfigure.ExceptionTranslatorExecuteListener;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionSubclassTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.util.Assert;

final class DefaultExceptionTranslatorExecuteListener
implements ExceptionTranslatorExecuteListener {
    private static final Log defaultLogger = LogFactory.getLog(ExceptionTranslatorExecuteListener.class);
    private final Log logger;
    private Function<ExecuteContext, SQLExceptionTranslator> translatorFactory;

    DefaultExceptionTranslatorExecuteListener() {
        this(defaultLogger, new DefaultTranslatorFactory());
    }

    DefaultExceptionTranslatorExecuteListener(Function<ExecuteContext, SQLExceptionTranslator> translatorFactory) {
        this(defaultLogger, translatorFactory);
    }

    DefaultExceptionTranslatorExecuteListener(Log logger) {
        this(logger, new DefaultTranslatorFactory());
    }

    private DefaultExceptionTranslatorExecuteListener(Log logger, Function<ExecuteContext, SQLExceptionTranslator> translatorFactory) {
        Assert.notNull(translatorFactory, (String)"'translatorFactory' must not be null");
        this.logger = logger;
        this.translatorFactory = translatorFactory;
    }

    public void exception(ExecuteContext context) {
        SQLExceptionTranslator translator = this.translatorFactory.apply(context);
        for (SQLException exception = context.sqlException(); exception != null; exception = exception.getNextException()) {
            this.handle(context, translator, exception);
        }
    }

    private void handle(ExecuteContext context, SQLExceptionTranslator translator, SQLException exception) {
        DataAccessException translated = translator.translate("jOOQ", context.sql(), exception);
        if (exception.getNextException() != null) {
            this.logger.error((Object)"Execution of SQL statement failed.", (Throwable)(translated != null ? translated : exception));
            return;
        }
        if (translated != null) {
            context.exception((RuntimeException)translated);
        }
    }

    private static final class DefaultTranslatorFactory
    implements Function<ExecuteContext, SQLExceptionTranslator> {
        private DefaultTranslatorFactory() {
        }

        @Override
        public SQLExceptionTranslator apply(ExecuteContext context) {
            return this.apply(context.configuration().dialect());
        }

        @Override
        private SQLExceptionTranslator apply(SQLDialect dialect) {
            String dbName = this.getSpringDbName(dialect);
            return dbName != null ? new SQLErrorCodeSQLExceptionTranslator(dbName) : new SQLExceptionSubclassTranslator();
        }

        private String getSpringDbName(SQLDialect dialect) {
            return dialect != null && dialect.thirdParty() != null ? dialect.thirdParty().springDbName() : null;
        }
    }
}

