/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jms.autoconfigure;

import io.micrometer.observation.ObservationRegistry;
import jakarta.jms.ConnectionFactory;
import java.time.Duration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.jms.autoconfigure.JmsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.core.JmsClient;
import org.springframework.jms.core.JmsMessageOperations;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;

abstract class JmsClientConfigurations {
    JmsClientConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JmsClient.class})
    static class JmsClientConfiguration {
        JmsClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={JmsClient.class})
        @ConditionalOnSingleCandidate(value=JmsTemplate.class)
        JmsClient jmsClient(JmsTemplate jmsTemplate) {
            return JmsClient.create((JmsOperations)jmsTemplate);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JmsMessagingTemplate.class})
    static class MessagingTemplateConfiguration {
        MessagingTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={JmsMessageOperations.class})
        @ConditionalOnSingleCandidate(value=JmsTemplate.class)
        JmsMessagingTemplate jmsMessagingTemplate(JmsProperties properties, JmsTemplate jmsTemplate) {
            JmsMessagingTemplate messagingTemplate = new JmsMessagingTemplate(jmsTemplate);
            this.mapTemplateProperties(properties.getTemplate(), messagingTemplate);
            return messagingTemplate;
        }

        private void mapTemplateProperties(JmsProperties.Template properties, JmsMessagingTemplate messagingTemplate) {
            PropertyMapper map = PropertyMapper.get();
            map.from(properties::getDefaultDestination).to(arg_0 -> ((JmsMessagingTemplate)messagingTemplate).setDefaultDestinationName(arg_0));
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class JmsTemplateConfiguration {
        private final JmsProperties properties;
        private final ObjectProvider<DestinationResolver> destinationResolver;
        private final ObjectProvider<MessageConverter> messageConverter;
        private final ObjectProvider<ObservationRegistry> observationRegistry;

        JmsTemplateConfiguration(JmsProperties properties, ObjectProvider<DestinationResolver> destinationResolver, ObjectProvider<MessageConverter> messageConverter, ObjectProvider<ObservationRegistry> observationRegistry) {
            this.properties = properties;
            this.destinationResolver = destinationResolver;
            this.messageConverter = messageConverter;
            this.observationRegistry = observationRegistry;
        }

        @Bean
        @ConditionalOnMissingBean(value={JmsOperations.class})
        @ConditionalOnSingleCandidate(value=ConnectionFactory.class)
        JmsTemplate jmsTemplate(ConnectionFactory connectionFactory) {
            PropertyMapper map = PropertyMapper.get();
            JmsTemplate template = new JmsTemplate(connectionFactory);
            template.setPubSubDomain(this.properties.isPubSubDomain());
            map.from(() -> this.destinationResolver.getIfUnique()).to(arg_0 -> ((JmsTemplate)template).setDestinationResolver(arg_0));
            map.from(() -> this.messageConverter.getIfUnique()).to(arg_0 -> ((JmsTemplate)template).setMessageConverter(arg_0));
            map.from(() -> this.observationRegistry.getIfUnique()).to(arg_0 -> ((JmsTemplate)template).setObservationRegistry(arg_0));
            this.mapTemplateProperties(this.properties.getTemplate(), template);
            return template;
        }

        private void mapTemplateProperties(JmsProperties.Template properties, JmsTemplate template) {
            PropertyMapper map = PropertyMapper.get();
            map.from(properties.getSession().getAcknowledgeMode()::getMode).to(arg_0 -> ((JmsTemplate)template).setSessionAcknowledgeMode(arg_0));
            map.from(properties.getSession()::isTransacted).to(arg_0 -> ((JmsTemplate)template).setSessionTransacted(arg_0));
            map.from(properties::getDefaultDestination).to(arg_0 -> ((JmsTemplate)template).setDefaultDestinationName(arg_0));
            map.from(properties::getDeliveryDelay).as(Duration::toMillis).to(arg_0 -> ((JmsTemplate)template).setDeliveryDelay(arg_0));
            map.from(properties::determineQosEnabled).to(arg_0 -> ((JmsTemplate)template).setExplicitQosEnabled(arg_0));
            map.from(properties::getDeliveryMode).as(JmsProperties.DeliveryMode::getValue).to(arg_0 -> ((JmsTemplate)template).setDeliveryMode(arg_0));
            map.from(properties::getPriority).to(arg_0 -> ((JmsTemplate)template).setPriority(arg_0));
            map.from(properties::getTimeToLive).as(Duration::toMillis).to(arg_0 -> ((JmsTemplate)template).setTimeToLive(arg_0));
            map.from(properties::getReceiveTimeout).as(Duration::toMillis).to(arg_0 -> ((JmsTemplate)template).setReceiveTimeout(arg_0));
        }
    }
}

