/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jersey.autoconfigure;

@FunctionalInterface
public interface JerseyApplicationPath {
    public String getPath();

    default public String getRelativePath(String path) {
        String prefix = this.getPrefix();
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return prefix + (String)path;
    }

    default public String getPrefix() {
        String result = this.getPath();
        int index = result.indexOf(42);
        if (index != -1) {
            result = result.substring(0, index);
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    default public String getUrlMapping() {
        Object path = this.getPath();
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (((String)path).equals("/")) {
            return "/*";
        }
        if (((String)path).contains("*")) {
            return path;
        }
        if (((String)path).endsWith("/")) {
            return (String)path + "*";
        }
        return (String)path + "/*";
    }
}

