/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.init;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jdbc.init.DataSourceScriptDatabaseInitializer;
import org.springframework.boot.jdbc.init.DatabaseInitializationProperties;
import org.springframework.boot.jdbc.init.PlatformPlaceholderDatabaseDriverResolver;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.util.StringUtils;

public class PropertiesBasedDataSourceScriptDatabaseInitializer<T extends DatabaseInitializationProperties>
extends DataSourceScriptDatabaseInitializer {
    public PropertiesBasedDataSourceScriptDatabaseInitializer(DataSource dataSource, T properties) {
        this(dataSource, properties, Collections.emptyMap());
    }

    public PropertiesBasedDataSourceScriptDatabaseInitializer(DataSource dataSource, T properties, Map<DatabaseDriver, String> driverMappings) {
        super(dataSource, PropertiesBasedDataSourceScriptDatabaseInitializer.getSettings(dataSource, properties, driverMappings));
    }

    private static <T extends DatabaseInitializationProperties> DatabaseInitializationSettings getSettings(DataSource dataSource, T properties, Map<DatabaseDriver, String> driverMappings) {
        DatabaseInitializationSettings settings = new DatabaseInitializationSettings();
        settings.setSchemaLocations(PropertiesBasedDataSourceScriptDatabaseInitializer.resolveSchemaLocations(dataSource, properties, driverMappings));
        settings.setMode(properties.getInitializeSchema());
        settings.setContinueOnError(properties.isContinueOnError());
        return settings;
    }

    private static <T extends DatabaseInitializationProperties> List<String> resolveSchemaLocations(DataSource dataSource, T properties, Map<DatabaseDriver, String> driverMappings) {
        PlatformPlaceholderDatabaseDriverResolver platformResolver = new PlatformPlaceholderDatabaseDriverResolver();
        for (Map.Entry<DatabaseDriver, String> entry : driverMappings.entrySet()) {
            platformResolver = platformResolver.withDriverPlatform(entry.getKey(), entry.getValue());
        }
        if (StringUtils.hasText((String)properties.getPlatform())) {
            return platformResolver.resolveAll(properties.getPlatform(), properties.getSchema());
        }
        return platformResolver.resolveAll(dataSource, properties.getSchema());
    }
}

