/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.tools;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jarmode.tools.Command;
import org.springframework.boot.jarmode.tools.Context;
import org.springframework.boot.jarmode.tools.ExtractCommand;
import org.springframework.boot.jarmode.tools.Layers;
import org.springframework.util.StringUtils;

class ExtractLayersCommand
extends Command {
    static final Command.Option DESTINATION_OPTION = Command.Option.of("destination", "string", "The destination to extract files to");
    private final ExtractCommand delegate;

    ExtractLayersCommand(Context context) {
        this(context, null);
    }

    ExtractLayersCommand(Context context, @Nullable Layers layers) {
        super("extract", "Extracts layers from the jar for image creation", Command.Options.of(DESTINATION_OPTION), Command.Parameters.of("[<layer>...]"));
        this.delegate = new ExtractCommand(context, layers);
    }

    @Override
    boolean isDeprecated() {
        return true;
    }

    @Override
    String getDeprecationMessage() {
        return "Use '-Djarmode=tools extract --layers --launcher' instead.";
    }

    @Override
    void run(PrintStream out, Map<Command.Option, @Nullable String> options, List<String> parameters) {
        HashMap<Command.Option, @Nullable String> rewrittenOptions = new HashMap<Command.Option, String>();
        rewrittenOptions.put(ExtractCommand.DESTINATION_OPTION, options.getOrDefault(DESTINATION_OPTION, "."));
        rewrittenOptions.put(ExtractCommand.LAYERS_OPTION, StringUtils.collectionToCommaDelimitedString(parameters));
        rewrittenOptions.put(ExtractCommand.LAUNCHER_OPTION, null);
        rewrittenOptions.put(ExtractCommand.FORCE_OPTION, null);
        this.delegate.run(out, rewrittenOptions, Collections.emptyList());
    }
}

