/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.layertools;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.JarFile;
import org.springframework.util.Assert;

class Context {
    private final File jarFile;
    private final File workingDir;
    private final String relativeDir;

    Context() {
        this(Context.getSourceJarFile(), Paths.get(".", new String[0]).toAbsolutePath().normalize().toFile());
    }

    Context(File jarFile, File workingDir) {
        Assert.state((jarFile != null && jarFile.isFile() && jarFile.exists() && jarFile.getName().toLowerCase().endsWith(".jar") ? 1 : 0) != 0, (String)"Unable to find source JAR");
        this.jarFile = jarFile;
        this.workingDir = workingDir;
        this.relativeDir = this.deduceRelativeDir(jarFile.getParentFile(), this.workingDir);
    }

    private static File getSourceJarFile() {
        try {
            File source;
            ProtectionDomain domain = Context.class.getProtectionDomain();
            CodeSource codeSource = domain != null ? domain.getCodeSource() : null;
            URL location = codeSource != null ? codeSource.getLocation() : null;
            File file = source = location != null ? Context.findSource(location) : null;
            if (source != null && source.exists()) {
                return source.getAbsoluteFile();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static File findSource(URL location) throws IOException, URISyntaxException {
        URLConnection connection = location.openConnection();
        if (connection instanceof JarURLConnection) {
            return Context.getRootJarFile(((JarURLConnection)connection).getJarFile());
        }
        return new File(location.toURI());
    }

    private static File getRootJarFile(JarFile jarFile) {
        String name = jarFile.getName();
        int separator = name.indexOf("!/");
        if (separator > 0) {
            name = name.substring(0, separator);
        }
        return new File(name);
    }

    private String deduceRelativeDir(File sourceDirectory, File workingDir) {
        String workingPath;
        String sourcePath = sourceDirectory.getAbsolutePath();
        if (sourcePath.equals(workingPath = workingDir.getAbsolutePath()) || !sourcePath.startsWith(workingPath)) {
            return null;
        }
        String relativePath = sourcePath.substring(workingPath.length() + 1);
        return !relativePath.isEmpty() ? relativePath : null;
    }

    File getJarFile() {
        return this.jarFile;
    }

    File getWorkingDir() {
        return this.workingDir;
    }

    String getRelativeJarDir() {
        return this.relativeDir;
    }
}

