/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.autoconfigure.actuate.endpoint;

import java.util.Collection;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.Show;
import org.springframework.boot.health.actuate.endpoint.AdditionalHealthEndpointPath;
import org.springframework.boot.health.actuate.endpoint.HealthEndpointGroup;
import org.springframework.boot.health.actuate.endpoint.HttpCodeStatusMapper;
import org.springframework.boot.health.actuate.endpoint.StatusAggregator;

class AutoConfiguredHealthEndpointGroup
implements HealthEndpointGroup {
    private final Predicate<String> members;
    private final StatusAggregator statusAggregator;
    private final HttpCodeStatusMapper httpCodeStatusMapper;
    private final @Nullable Show showComponents;
    private final Show showDetails;
    private final Collection<String> roles;
    private final @Nullable AdditionalHealthEndpointPath additionalPath;

    AutoConfiguredHealthEndpointGroup(Predicate<String> members, StatusAggregator statusAggregator, HttpCodeStatusMapper httpCodeStatusMapper, @Nullable Show showComponents, Show showDetails, Collection<String> roles, @Nullable AdditionalHealthEndpointPath additionalPath) {
        this.members = members;
        this.statusAggregator = statusAggregator;
        this.httpCodeStatusMapper = httpCodeStatusMapper;
        this.showComponents = showComponents;
        this.showDetails = showDetails;
        this.roles = roles;
        this.additionalPath = additionalPath;
    }

    @Override
    public boolean isMember(String name) {
        return this.members.test(name);
    }

    @Override
    public boolean showComponents(SecurityContext securityContext) {
        Show show = this.showComponents != null ? this.showComponents : this.showDetails;
        return show.isShown(securityContext, this.roles);
    }

    @Override
    public boolean showDetails(SecurityContext securityContext) {
        return this.showDetails.isShown(securityContext, this.roles);
    }

    @Override
    public StatusAggregator getStatusAggregator() {
        return this.statusAggregator;
    }

    @Override
    public HttpCodeStatusMapper getHttpCodeStatusMapper() {
        return this.httpCodeStatusMapper;
    }

    @Override
    public @Nullable AdditionalHealthEndpointPath getAdditionalPath() {
        return this.additionalPath;
    }
}

