/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.autoconfigure.actuate.endpoint;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.Show;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.health.autoconfigure.actuate.endpoint.HealthProperties;

@ConfigurationProperties(value="management.endpoint.health")
public class HealthEndpointProperties
extends HealthProperties {
    private Show showDetails = Show.NEVER;
    private final Map<String, Group> group = new LinkedHashMap<String, Group>();
    private final Logging logging = new Logging();

    @Override
    public Show getShowDetails() {
        return this.showDetails;
    }

    public void setShowDetails(Show showDetails) {
        this.showDetails = showDetails;
    }

    public Map<String, Group> getGroup() {
        return this.group;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public static class Logging {
        private Duration slowIndicatorThreshold = Duration.ofSeconds(10L);

        public Duration getSlowIndicatorThreshold() {
            return this.slowIndicatorThreshold;
        }

        public void setSlowIndicatorThreshold(Duration slowIndicatorThreshold) {
            this.slowIndicatorThreshold = slowIndicatorThreshold;
        }
    }

    public static class Group
    extends HealthProperties {
        public static final String SERVER_PREFIX = "server:";
        public static final String MANAGEMENT_PREFIX = "management:";
        private @Nullable Set<String> include;
        private @Nullable Set<String> exclude;
        private @Nullable Show showDetails;
        private @Nullable String additionalPath;

        public @Nullable Set<String> getInclude() {
            return this.include;
        }

        public void setInclude(@Nullable Set<String> include) {
            this.include = include;
        }

        public @Nullable Set<String> getExclude() {
            return this.exclude;
        }

        public void setExclude(@Nullable Set<String> exclude) {
            this.exclude = exclude;
        }

        @Override
        public @Nullable Show getShowDetails() {
            return this.showDetails;
        }

        public void setShowDetails(@Nullable Show showDetails) {
            this.showDetails = showDetails;
        }

        public @Nullable String getAdditionalPath() {
            return this.additionalPath;
        }

        public void setAdditionalPath(@Nullable String additionalPath) {
            this.additionalPath = additionalPath;
        }
    }
}

