/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.autoconfigure.registry;

import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@FunctionalInterface
public interface HealthContributorNameGenerator {
    public String generateContributorName(String var1);

    default public <C> Consumer<BiConsumer<String, C>> registrar(Map<String, C> contributorBeans) {
        return initialRegistrations -> contributorBeans.forEach((beanName, contributorBean) -> {
            String contributorName = this.generateContributorName((String)beanName);
            try {
                initialRegistrations.accept(contributorName, contributorBean);
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException("Unable to register contributor named '%s' of type %s from bean '%s': %s".formatted(contributorName, contributorBean.getClass(), beanName, ex.getMessage()), ex);
            }
        });
    }

    public static HealthContributorNameGenerator unchanged() {
        return beanName -> beanName;
    }

    public static HealthContributorNameGenerator withoutStandardSuffixes() {
        return HealthContributorNameGenerator.withoutSuffixes("healthindicator", "healthcontributor");
    }

    public static HealthContributorNameGenerator withoutSuffixes(String ... suffixes) {
        return beanName -> {
            for (String suffix : suffixes) {
                if (beanName == null || !beanName.toLowerCase(Locale.ENGLISH).endsWith(suffix)) continue;
                return beanName.substring(0, beanName.length() - suffix.length());
            }
            return beanName;
        };
    }
}

