/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.hazelcast.autoconfigure;

import com.hazelcast.client.config.ClientConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.hazelcast.autoconfigure.HazelcastClientConfigAvailableCondition;
import org.springframework.boot.hazelcast.autoconfigure.HazelcastConnectionDetails;
import org.springframework.boot.hazelcast.autoconfigure.HazelcastProperties;
import org.springframework.boot.hazelcast.autoconfigure.PropertiesHazelcastConnectionDetails;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={HazelcastConnectionDetails.class})
class HazelcastConnectionDetailsConfiguration {
    HazelcastConnectionDetailsConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSingleCandidate(value=ClientConfig.class)
    static class HazelcastClientConfigConfiguration {
        HazelcastClientConfigConfiguration() {
        }

        @Bean
        HazelcastConnectionDetails hazelcastConnectionDetails(ClientConfig config) {
            return () -> config;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={ClientConfig.class})
    @Conditional(value={HazelcastClientConfigAvailableCondition.class})
    static class HazelcastClientConfigFileConfiguration {
        HazelcastClientConfigFileConfiguration() {
        }

        @Bean
        HazelcastConnectionDetails hazelcastConnectionDetails(HazelcastProperties properties, ResourceLoader resourceLoader) {
            return new PropertiesHazelcastConnectionDetails(properties, resourceLoader);
        }
    }
}

