/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.hazelcast.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ResourceCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;

public abstract class HazelcastConfigResourceCondition
extends ResourceCondition {
    protected static final String HAZELCAST_CONFIG_PROPERTY = "spring.hazelcast.config";
    private final String configSystemProperty;

    protected HazelcastConfigResourceCondition(String configSystemProperty, String ... resourceLocations) {
        super("Hazelcast", HAZELCAST_CONFIG_PROPERTY, resourceLocations);
        Assert.notNull((Object)configSystemProperty, (String)"'configSystemProperty' must not be null");
        this.configSystemProperty = configSystemProperty;
    }

    protected ConditionOutcome getResourceOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        if (System.getProperty(this.configSystemProperty) != null) {
            return ConditionOutcome.match((ConditionMessage)this.startConditionMessage().because("System property '" + this.configSystemProperty + "' is set."));
        }
        return super.getResourceOutcome(context, metadata);
    }
}

