/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.graphql.autoconfigure.data;

import graphql.GraphQL;
import java.util.Collections;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.graphql.autoconfigure.GraphQlAutoConfiguration;
import org.springframework.boot.graphql.autoconfigure.GraphQlSourceBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.data.repository.query.ReactiveQueryByExampleExecutor;
import org.springframework.graphql.data.query.QueryByExampleDataFetcher;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;

@AutoConfiguration(after={GraphQlAutoConfiguration.class})
@ConditionalOnClass(value={GraphQL.class, QueryByExampleDataFetcher.class, ReactiveQueryByExampleExecutor.class})
@ConditionalOnBean(value={GraphQlSource.class})
public final class GraphQlReactiveQueryByExampleAutoConfiguration {
    @Bean
    GraphQlSourceBuilderCustomizer reactiveQueryByExampleRegistrar(ObjectProvider<ReactiveQueryByExampleExecutor<?>> reactiveExecutors) {
        RuntimeWiringConfigurer configurer = QueryByExampleDataFetcher.autoRegistrationConfigurer(Collections.emptyList(), reactiveExecutors.orderedStream().toList());
        return builder -> builder.configureRuntimeWiring(configurer);
    }
}

