/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.graphql.autoconfigure.rsocket;

import graphql.GraphQL;
import io.rsocket.core.RSocketServer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.graphql.autoconfigure.GraphQlAutoConfiguration;
import org.springframework.boot.graphql.autoconfigure.rsocket.GraphQlRSocketController;
import org.springframework.context.annotation.Bean;
import org.springframework.core.codec.Encoder;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerConfigurer;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.server.GraphQlRSocketHandler;
import org.springframework.graphql.server.RSocketGraphQlInterceptor;
import org.springframework.http.codec.json.JacksonJsonEncoder;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import reactor.netty.http.server.HttpServer;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration(after={GraphQlAutoConfiguration.class}, afterName={"org.springframework.boot.rsocket.autoconfigure.RSocketMessagingAutoConfiguration"})
@ConditionalOnClass(value={GraphQL.class, GraphQlSource.class, RSocketServer.class, HttpServer.class})
@ConditionalOnBean(value={RSocketMessageHandler.class, AnnotatedControllerConfigurer.class})
@ConditionalOnProperty(value={"spring.graphql.rsocket.mapping"})
public final class GraphQlRSocketAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    GraphQlRSocketHandler graphQlRSocketHandler(ExecutionGraphQlService graphQlService, ObjectProvider<RSocketGraphQlInterceptor> interceptors, JsonMapper jsonMapper) {
        return new GraphQlRSocketHandler(graphQlService, interceptors.orderedStream().toList(), (Encoder)new JacksonJsonEncoder(jsonMapper));
    }

    @Bean
    @ConditionalOnMissingBean
    GraphQlRSocketController graphQlRSocketController(GraphQlRSocketHandler handler) {
        return new GraphQlRSocketController(handler);
    }
}

