/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.io.File;
import java.util.Set;
import java.util.jar.JarFile;
import org.gradle.api.specs.Spec;

class JarTypeFileSpec
implements Spec<File> {
    private static final Set<String> EXCLUDED_JAR_TYPES = Set.of("dependencies-starter", "development-tool");

    JarTypeFileSpec() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSatisfiedBy(File file) {
        try (JarFile jar = new JarFile(file);){
            String jarType = jar.getManifest().getMainAttributes().getValue("Spring-Boot-Jar-Type");
            if (jarType == null) return true;
            if (!EXCLUDED_JAR_TYPES.contains(jarType)) return true;
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

