/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.aot;

import java.io.File;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.gradle.tasks.aot.AbstractAot;
import org.springframework.util.Assert;

@CacheableTask
public abstract class ProcessTestAot
extends AbstractAot {
    private @Nullable FileCollection classpathRoots;

    public ProcessTestAot() {
        this.getMainClass().set((Object)"org.springframework.boot.test.context.SpringBootTestAotProcessor");
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public final @Nullable FileCollection getClasspathRoots() {
        return this.classpathRoots;
    }

    public void setClasspathRoots(FileCollection classpathRoots) {
        this.classpathRoots = classpathRoots;
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    final FileTree getInputClasses() {
        Assert.state((this.classpathRoots != null ? 1 : 0) != 0, (String)"'classpathRoots' must not be null");
        return this.classpathRoots.getAsFileTree();
    }

    @TaskAction
    public void exec() {
        ArrayList<String> args = new ArrayList<String>();
        FileCollection classpathRoots = this.getClasspathRoots();
        Assert.state((classpathRoots != null ? 1 : 0) != 0, (String)"'classpathRoots' must not be null");
        args.add(classpathRoots.getFiles().stream().filter(File::exists).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
        args.addAll(this.processorArgs());
        this.setArgs(args);
        super.exec();
    }
}

