/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.elasticsearch.testcontainers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.elasticsearch.autoconfigure.ElasticsearchConnectionDetails;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.springframework.boot.testcontainers.service.connection.Ssl;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

class ElasticsearchContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<ElasticsearchContainer, ElasticsearchConnectionDetails> {
    private static final int DEFAULT_PORT = 9200;

    ElasticsearchContainerConnectionDetailsFactory() {
    }

    protected ElasticsearchConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<ElasticsearchContainer> source) {
        return new ElasticsearchContainerConnectionDetails(source);
    }

    private static final class ElasticsearchContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<ElasticsearchContainer>
    implements ElasticsearchConnectionDetails {
        private volatile @Nullable SslBundle sslBundle;

        private ElasticsearchContainerConnectionDetails(ContainerConnectionSource<ElasticsearchContainer> source) {
            super(source);
        }

        @Override
        public String getUsername() {
            return "elastic";
        }

        @Override
        public @Nullable String getPassword() {
            return (String)((ElasticsearchContainer)this.getContainer()).getEnvMap().get("ELASTIC_PASSWORD");
        }

        @Override
        public List<ElasticsearchConnectionDetails.Node> getNodes() {
            String host = ((ElasticsearchContainer)this.getContainer()).getHost();
            Integer port = ((ElasticsearchContainer)this.getContainer()).getMappedPort(9200);
            return List.of(new ElasticsearchConnectionDetails.Node(host, port, this.getSslBundle() != null ? ElasticsearchConnectionDetails.Node.Protocol.HTTPS : ElasticsearchConnectionDetails.Node.Protocol.HTTP, this.getUsername(), this.getPassword()));
        }

        @Override
        public @Nullable SslBundle getSslBundle() {
            byte[] caCertificate;
            if (this.sslBundle != null) {
                return this.sslBundle;
            }
            SslBundle sslBundle = super.getSslBundle();
            if (sslBundle != null) {
                this.sslBundle = sslBundle;
                return sslBundle;
            }
            if (this.hasAnnotation(Ssl.class) && (caCertificate = (byte[])((ElasticsearchContainer)this.getContainer()).caCertAsBytes().orElse(null)) != null) {
                KeyStore trustStore = this.createTrustStore(caCertificate);
                this.sslBundle = sslBundle = this.createSslBundleWithTrustStore(trustStore);
                return sslBundle;
            }
            return null;
        }

        private SslBundle createSslBundleWithTrustStore(KeyStore trustStore) {
            return SslBundle.of((SslStoreBundle)SslStoreBundle.of(null, null, (KeyStore)trustStore));
        }

        private KeyStore createTrustStore(byte[] caCertificate) {
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                Certificate certificate = certFactory.generateCertificate(new ByteArrayInputStream(caCertificate));
                keyStore.setCertificateEntry("ca", certificate);
                return keyStore;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                throw new IllegalStateException("Failed to create keystore from CA certificate", ex);
            }
        }
    }
}

