/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.container.ContainerImageMetadata;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactories;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.lifecycle.DockerComposeServicesReadyEvent;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.AttributeAccessor;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class DockerComposeServiceConnectionsApplicationListener
implements ApplicationListener<DockerComposeServicesReadyEvent> {
    private final ConnectionDetailsFactories factories;

    DockerComposeServiceConnectionsApplicationListener() {
        this(new ConnectionDetailsFactories(null));
    }

    DockerComposeServiceConnectionsApplicationListener(ConnectionDetailsFactories factories) {
        this.factories = factories;
    }

    public void onApplicationEvent(DockerComposeServicesReadyEvent event) {
        ApplicationContext applicationContext = event.getSource();
        if (applicationContext instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)applicationContext;
            Environment environment = applicationContext.getEnvironment();
            this.registerConnectionDetails(registry, environment, event.getRunningServices());
        }
    }

    private void registerConnectionDetails(BeanDefinitionRegistry registry, Environment environment, List<RunningService> runningServices) {
        for (RunningService runningService : runningServices) {
            DockerComposeConnectionSource source = new DockerComposeConnectionSource(runningService, environment);
            this.factories.getConnectionDetails((Object)source, false).forEach((connectionDetailsType, connectionDetails) -> {
                this.register(registry, runningService, (Class<?>)connectionDetailsType, (ConnectionDetails)connectionDetails);
                this.factories.getConnectionDetails(connectionDetails, false).forEach((adaptedType, adaptedDetails) -> this.register(registry, runningService, (Class<?>)adaptedType, (ConnectionDetails)adaptedDetails));
            });
        }
    }

    private <T> void register(BeanDefinitionRegistry registry, RunningService runningService, Class<?> connectionDetailsType, ConnectionDetails connectionDetails) {
        ContainerImageMetadata containerMetadata = new ContainerImageMetadata(runningService.image().toString());
        String beanName = this.getBeanName(runningService, connectionDetailsType);
        Class beanType = connectionDetails.getClass();
        Supplier<Object> beanSupplier = () -> connectionDetails;
        RootBeanDefinition beanDefinition = new RootBeanDefinition(beanType, beanSupplier);
        containerMetadata.addTo((AttributeAccessor)beanDefinition);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    private String getBeanName(RunningService runningService, Class<?> connectionDetailsType) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(ClassUtils.getShortNameAsProperty(connectionDetailsType));
        parts.add("for");
        parts.addAll(Arrays.asList(runningService.name().split("-")));
        return StringUtils.uncapitalize((String)parts.stream().map(StringUtils::capitalize).collect(Collectors.joining()));
    }
}

