/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.lifecycle;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.SpringApplicationAotProcessor;
import org.springframework.boot.docker.compose.lifecycle.DockerComposeProperties;
import org.springframework.util.ClassUtils;

class DockerComposeSkipCheck {
    private static final Set<String> REQUIRED_CLASSES = Set.of("org.junit.jupiter.api.Test", "org.junit.Test");
    private static final Set<String> SKIPPED_STACK_ELEMENTS;

    DockerComposeSkipCheck() {
    }

    boolean shouldSkip(@Nullable ClassLoader classLoader, DockerComposeProperties.Skip properties) {
        if (properties.isInTests() && this.hasAtLeastOneRequiredClass(classLoader)) {
            Thread thread = Thread.currentThread();
            for (StackTraceElement element : thread.getStackTrace()) {
                if (!DockerComposeSkipCheck.isSkippedStackElement(element)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAtLeastOneRequiredClass(@Nullable ClassLoader classLoader) {
        for (String requiredClass : REQUIRED_CLASSES) {
            if (!ClassUtils.isPresent((String)requiredClass, (ClassLoader)classLoader)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSkippedStackElement(StackTraceElement element) {
        for (String skipped : SKIPPED_STACK_ELEMENTS) {
            if (!element.getClassName().startsWith(skipped)) continue;
            return true;
        }
        return false;
    }

    static {
        LinkedHashSet<String> skipped = new LinkedHashSet<String>();
        skipped.add("org.junit.runners.");
        skipped.add("org.junit.platform.");
        skipped.add("org.springframework.boot.test.");
        skipped.add(SpringApplicationAotProcessor.class.getName());
        skipped.add("cucumber.runtime.");
        SKIPPED_STACK_ELEMENTS = Collections.unmodifiableSet(skipped);
    }
}

