/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.lifecycle;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.lifecycle.ServiceNotReadyException;

public final class ReadinessTimeoutException
extends RuntimeException {
    private final Duration timeout;

    ReadinessTimeoutException(Duration timeout, List<ServiceNotReadyException> exceptions) {
        super(ReadinessTimeoutException.buildMessage(timeout, exceptions));
        this.timeout = timeout;
        exceptions.forEach(this::addSuppressed);
    }

    private static String buildMessage(Duration timeout, List<ServiceNotReadyException> exceptions) {
        List<String> serviceNames = exceptions.stream().map(ServiceNotReadyException::getService).filter(Objects::nonNull).map(RunningService::name).toList();
        return "Readiness timeout of %s reached while waiting for services %s".formatted(timeout, serviceNames);
    }

    public Duration getTimeout() {
        return this.timeout;
    }
}

