/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.mysql;

import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.jdbc.JdbcUrlBuilder;
import org.springframework.boot.docker.compose.service.connection.mysql.MySqlEnvironment;

class MySqlJdbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<JdbcConnectionDetails> {
    private static final String[] MYSQL_CONTAINER_NAMES = new String[]{"mysql", "bitnami/mysql", "bitnamilegacy/mysql"};

    protected MySqlJdbcDockerComposeConnectionDetailsFactory() {
        super(MYSQL_CONTAINER_NAMES, new String[0]);
    }

    @Override
    protected JdbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new MySqlJdbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class MySqlJdbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements JdbcConnectionDetails {
        private static final JdbcUrlBuilder jdbcUrlBuilder = new JdbcUrlBuilder("mysql", 3306);
        private final MySqlEnvironment environment;
        private final String jdbcUrl;

        MySqlJdbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new MySqlEnvironment(service.env());
            this.jdbcUrl = jdbcUrlBuilder.build(service, this.environment.getDatabase());
        }

        public String getUsername() {
            return this.environment.getUsername();
        }

        public String getPassword() {
            return this.environment.getPassword();
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }
    }
}

