/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.otlp;

import org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpMetricsConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class OpenTelemetryMetricsDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<OtlpMetricsConnectionDetails> {
    private static final int OTLP_PORT = 4318;

    OpenTelemetryMetricsDockerComposeConnectionDetailsFactory() {
        super("otel/opentelemetry-collector-contrib", "org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpMetricsExportAutoConfiguration");
    }

    @Override
    protected OtlpMetricsConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new OpenTelemetryMetricsDockerComposeConnectionDetails(source.getRunningService());
    }

    private static final class OpenTelemetryMetricsDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements OtlpMetricsConnectionDetails {
        private final String host;
        private final int port;

        private OpenTelemetryMetricsDockerComposeConnectionDetails(RunningService source) {
            super(source);
            this.host = source.host();
            this.port = source.ports().get(4318);
        }

        public String getUrl() {
            return "http://%s:%d/v1/metrics".formatted(this.host, this.port);
        }
    }
}

