/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcAutoConfiguration;
import org.springframework.boot.devtools.autoconfigure.OnEnabledDevToolsCondition;
import org.springframework.boot.r2dbc.EmbeddedDatabaseConnection;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import reactor.core.publisher.Mono;

@ConditionalOnClass(value={ConnectionFactory.class})
@Conditional(value={OnEnabledDevToolsCondition.class, DevToolsConnectionFactoryCondition.class})
@AutoConfiguration(after={R2dbcAutoConfiguration.class})
public class DevToolsR2dbcAutoConfiguration {
    @Bean
    InMemoryR2dbcDatabaseShutdownExecutor inMemoryR2dbcDatabaseShutdownExecutor(ApplicationEventPublisher eventPublisher, ConnectionFactory connectionFactory) {
        return new InMemoryR2dbcDatabaseShutdownExecutor(eventPublisher, connectionFactory);
    }

    final class InMemoryR2dbcDatabaseShutdownExecutor
    implements DisposableBean {
        private final ApplicationEventPublisher eventPublisher;
        private final ConnectionFactory connectionFactory;

        InMemoryR2dbcDatabaseShutdownExecutor(ApplicationEventPublisher eventPublisher, ConnectionFactory connectionFactory) {
            this.eventPublisher = eventPublisher;
            this.connectionFactory = connectionFactory;
        }

        public void destroy() throws Exception {
            if (this.shouldShutdown()) {
                Mono.usingWhen((Publisher)this.connectionFactory.create(), this::executeShutdown, this::closeConnection, this::closeConnection, this::closeConnection).block();
                this.eventPublisher.publishEvent((Object)new R2dbcDatabaseShutdownEvent(this.connectionFactory));
            }
        }

        private boolean shouldShutdown() {
            try {
                return EmbeddedDatabaseConnection.isEmbedded((ConnectionFactory)this.connectionFactory);
            }
            catch (Exception ex) {
                return false;
            }
        }

        private Mono<?> executeShutdown(Connection connection) {
            return Mono.from((Publisher)connection.createStatement("SHUTDOWN").execute());
        }

        private Publisher<Void> closeConnection(Connection connection) {
            return this.closeConnection(connection, null);
        }

        private Publisher<Void> closeConnection(Connection connection, Throwable ex) {
            return connection.close();
        }
    }

    static class R2dbcDatabaseShutdownEvent {
        private final ConnectionFactory connectionFactory;

        R2dbcDatabaseShutdownEvent(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        ConnectionFactory getConnectionFactory() {
            return this.connectionFactory;
        }
    }

    static class DevToolsConnectionFactoryCondition
    extends SpringBootCondition
    implements ConfigurationCondition {
        DevToolsConnectionFactoryCondition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            AnnotatedBeanDefinition annotatedBeanDefinition;
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"DevTools ConnectionFactory Condition", (Object[])new Object[0]);
            String[] beanNames = context.getBeanFactory().getBeanNamesForType(ConnectionFactory.class, true, false);
            if (beanNames.length != 1) {
                return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("a single ConnectionFactory bean").atAll());
            }
            BeanDefinition beanDefinition = context.getRegistry().getBeanDefinition(beanNames[0]);
            if (beanDefinition instanceof AnnotatedBeanDefinition && this.isAutoConfigured(annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition)) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"auto-configured ConnectionFactory"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("an auto-configured ConnectionFactory").atAll());
        }

        private boolean isAutoConfigured(AnnotatedBeanDefinition beanDefinition) {
            MethodMetadata methodMetadata = beanDefinition.getFactoryMethodMetadata();
            return methodMetadata != null && methodMetadata.getDeclaringClassName().startsWith(R2dbcAutoConfiguration.class.getPackage().getName());
        }
    }
}

