/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.devtools.livereload.LiveReloadServer;

public class OptionalLiveReloadServer {
    private static final Log logger = LogFactory.getLog(OptionalLiveReloadServer.class);
    private LiveReloadServer server;

    public OptionalLiveReloadServer(LiveReloadServer server) {
        this.server = server;
    }

    @PostConstruct
    public void startServer() throws Exception {
        if (this.server != null) {
            try {
                if (!this.server.isStarted()) {
                    this.server.start();
                }
                logger.info((Object)("LiveReload server is running on port " + this.server.getPort()));
            }
            catch (Exception ex) {
                logger.warn((Object)"Unable to start LiveReload server");
                logger.debug((Object)"Live reload start error", (Throwable)ex);
                this.server = null;
            }
        }
    }

    public void triggerReload() {
        if (this.server != null) {
            this.server.triggerReload();
        }
    }
}

