/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.remote.client;

import javax.net.ServerSocketFactory;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.devtools.autoconfigure.RemoteDevToolsProperties;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

class LocalDebugPortAvailableCondition
extends SpringBootCondition {
    LocalDebugPortAvailableCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Local Debug Port Condition", (Object[])new Object[0]);
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), "spring.devtools.remote.debug.");
        Integer port = (Integer)resolver.getProperty("local-port", Integer.class);
        if (port == null) {
            port = RemoteDevToolsProperties.Debug.DEFAULT_LOCAL_PORT;
        }
        if (this.isPortAvailable(port)) {
            return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"local debug port"));
        }
        return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("local debug port").atAll());
    }

    private boolean isPortAvailable(int port) {
        try {
            ServerSocketFactory.getDefault().createServerSocket(port).close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

