/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.rest.autoconfigure;

import java.util.List;
import org.springframework.boot.data.rest.autoconfigure.DataRestProperties;
import org.springframework.boot.jackson.autoconfigure.JsonMapperBuilderCustomizer;
import org.springframework.core.annotation.Order;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.json.JsonMapper;

@Order(value=0)
class SpringBootRepositoryRestConfigurer
implements RepositoryRestConfigurer {
    private final List<JsonMapperBuilderCustomizer> jsonMapperBuilderCustomizers;
    private final DataRestProperties properties;

    SpringBootRepositoryRestConfigurer(List<JsonMapperBuilderCustomizer> jsonMapperBuilderCustomizers, DataRestProperties properties) {
        this.jsonMapperBuilderCustomizers = jsonMapperBuilderCustomizers;
        this.properties = properties;
    }

    public void configureRepositoryRestConfiguration(RepositoryRestConfiguration config, CorsRegistry cors) {
        this.properties.applyTo(config);
    }

    public void configureJacksonObjectMapper(MapperBuilder<?, ?> mapperBuilder) {
        if (mapperBuilder instanceof JsonMapper.Builder) {
            JsonMapper.Builder jsonMapperBuilder = (JsonMapper.Builder)mapperBuilder;
            this.jsonMapperBuilderCustomizers.forEach(customizer -> customizer.customize(jsonMapperBuilder));
        }
    }
}

