/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.rest.autoconfigure;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.RepositoryDetectionStrategy;
import org.springframework.http.MediaType;

@ConfigurationProperties(value="spring.data.rest")
public class RepositoryRestProperties {
    private @Nullable String basePath;
    private @Nullable Integer defaultPageSize;
    private @Nullable Integer maxPageSize;
    private @Nullable String pageParamName;
    private @Nullable String limitParamName;
    private @Nullable String sortParamName;
    private RepositoryDetectionStrategy.RepositoryDetectionStrategies detectionStrategy = RepositoryDetectionStrategy.RepositoryDetectionStrategies.DEFAULT;
    private @Nullable MediaType defaultMediaType;
    private @Nullable Boolean returnBodyOnCreate;
    private @Nullable Boolean returnBodyOnUpdate;
    private @Nullable Boolean enableEnumTranslation;

    public @Nullable String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(@Nullable String basePath) {
        this.basePath = basePath;
    }

    public @Nullable Integer getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public void setDefaultPageSize(@Nullable Integer defaultPageSize) {
        this.defaultPageSize = defaultPageSize;
    }

    public @Nullable Integer getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setMaxPageSize(@Nullable Integer maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public @Nullable String getPageParamName() {
        return this.pageParamName;
    }

    public void setPageParamName(@Nullable String pageParamName) {
        this.pageParamName = pageParamName;
    }

    public @Nullable String getLimitParamName() {
        return this.limitParamName;
    }

    public void setLimitParamName(@Nullable String limitParamName) {
        this.limitParamName = limitParamName;
    }

    public @Nullable String getSortParamName() {
        return this.sortParamName;
    }

    public void setSortParamName(@Nullable String sortParamName) {
        this.sortParamName = sortParamName;
    }

    public RepositoryDetectionStrategy.RepositoryDetectionStrategies getDetectionStrategy() {
        return this.detectionStrategy;
    }

    public void setDetectionStrategy(RepositoryDetectionStrategy.RepositoryDetectionStrategies detectionStrategy) {
        this.detectionStrategy = detectionStrategy;
    }

    public @Nullable MediaType getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(@Nullable MediaType defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }

    public @Nullable Boolean getReturnBodyOnCreate() {
        return this.returnBodyOnCreate;
    }

    public void setReturnBodyOnCreate(@Nullable Boolean returnBodyOnCreate) {
        this.returnBodyOnCreate = returnBodyOnCreate;
    }

    public @Nullable Boolean getReturnBodyOnUpdate() {
        return this.returnBodyOnUpdate;
    }

    public void setReturnBodyOnUpdate(@Nullable Boolean returnBodyOnUpdate) {
        this.returnBodyOnUpdate = returnBodyOnUpdate;
    }

    public @Nullable Boolean getEnableEnumTranslation() {
        return this.enableEnumTranslation;
    }

    public void setEnableEnumTranslation(@Nullable Boolean enableEnumTranslation) {
        this.enableEnumTranslation = enableEnumTranslation;
    }

    public void applyTo(RepositoryRestConfiguration rest) {
        PropertyMapper map = PropertyMapper.get();
        map.from(this::getBasePath).to(arg_0 -> ((RepositoryRestConfiguration)rest).setBasePath(arg_0));
        map.from(this::getDefaultPageSize).to(arg_0 -> ((RepositoryRestConfiguration)rest).setDefaultPageSize(arg_0));
        map.from(this::getMaxPageSize).to(arg_0 -> ((RepositoryRestConfiguration)rest).setMaxPageSize(arg_0));
        map.from(this::getPageParamName).to(arg_0 -> ((RepositoryRestConfiguration)rest).setPageParamName(arg_0));
        map.from(this::getLimitParamName).to(arg_0 -> ((RepositoryRestConfiguration)rest).setLimitParamName(arg_0));
        map.from(this::getSortParamName).to(arg_0 -> ((RepositoryRestConfiguration)rest).setSortParamName(arg_0));
        map.from(this::getDetectionStrategy).to(arg_0 -> ((RepositoryRestConfiguration)rest).setRepositoryDetectionStrategy(arg_0));
        map.from(this::getDefaultMediaType).to(arg_0 -> ((RepositoryRestConfiguration)rest).setDefaultMediaType(arg_0));
        map.from(this::getReturnBodyOnCreate).to(arg_0 -> ((RepositoryRestConfiguration)rest).setReturnBodyOnCreate(arg_0));
        map.from(this::getReturnBodyOnUpdate).to(arg_0 -> ((RepositoryRestConfiguration)rest).setReturnBodyOnUpdate(arg_0));
        map.from(this::getEnableEnumTranslation).to(arg_0 -> ((RepositoryRestConfiguration)rest).setEnableEnumTranslation(arg_0));
    }
}

