/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure;

import java.time.Duration;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.data.redis")
public class DataRedisProperties {
    private int database;
    private @Nullable String url;
    private String host = "localhost";
    private @Nullable String username;
    private @Nullable String password;
    private int port = 6379;
    private @Nullable Duration timeout;
    private @Nullable Duration connectTimeout;
    private @Nullable String clientName;
    private @Nullable ClientType clientType;
    private @Nullable Sentinel sentinel;
    private @Nullable Cluster cluster;
    private @Nullable Masterreplica masterreplica;
    private final Ssl ssl = new Ssl();
    private final Jedis jedis = new Jedis();
    private final Lettuce lettuce = new Lettuce();

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public @Nullable String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public @Nullable String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public @Nullable Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@Nullable Duration timeout) {
        this.timeout = timeout;
    }

    public @Nullable Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(@Nullable Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public @Nullable String getClientName() {
        return this.clientName;
    }

    public void setClientName(@Nullable String clientName) {
        this.clientName = clientName;
    }

    public @Nullable ClientType getClientType() {
        return this.clientType;
    }

    public void setClientType(@Nullable ClientType clientType) {
        this.clientType = clientType;
    }

    public @Nullable Sentinel getSentinel() {
        return this.sentinel;
    }

    public void setSentinel(@Nullable Sentinel sentinel) {
        this.sentinel = sentinel;
    }

    public @Nullable Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(@Nullable Cluster cluster) {
        this.cluster = cluster;
    }

    public @Nullable Masterreplica getMasterreplica() {
        return this.masterreplica;
    }

    public void setMasterreplica(@Nullable Masterreplica masterreplica) {
        this.masterreplica = masterreplica;
    }

    public Jedis getJedis() {
        return this.jedis;
    }

    public Lettuce getLettuce() {
        return this.lettuce;
    }

    public static class Ssl {
        private @Nullable Boolean enabled;
        private @Nullable String bundle;

        public boolean isEnabled() {
            return this.enabled != null ? this.enabled : this.bundle != null;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public @Nullable String getBundle() {
            return this.bundle;
        }

        public void setBundle(@Nullable String bundle) {
            this.bundle = bundle;
        }
    }

    public static class Jedis {
        private final Pool pool = new Pool();

        public Pool getPool() {
            return this.pool;
        }
    }

    public static class Lettuce {
        private Duration shutdownTimeout = Duration.ofMillis(100L);
        private @Nullable String readFrom;
        private final Pool pool = new Pool();
        private final Cluster cluster = new Cluster();

        public Duration getShutdownTimeout() {
            return this.shutdownTimeout;
        }

        public void setShutdownTimeout(Duration shutdownTimeout) {
            this.shutdownTimeout = shutdownTimeout;
        }

        public @Nullable String getReadFrom() {
            return this.readFrom;
        }

        public void setReadFrom(@Nullable String readFrom) {
            this.readFrom = readFrom;
        }

        public Pool getPool() {
            return this.pool;
        }

        public Cluster getCluster() {
            return this.cluster;
        }

        public static class Cluster {
            private final Refresh refresh = new Refresh();

            public Refresh getRefresh() {
                return this.refresh;
            }

            public static class Refresh {
                private boolean dynamicRefreshSources = true;
                private @Nullable Duration period;
                private boolean adaptive;

                public boolean isDynamicRefreshSources() {
                    return this.dynamicRefreshSources;
                }

                public void setDynamicRefreshSources(boolean dynamicRefreshSources) {
                    this.dynamicRefreshSources = dynamicRefreshSources;
                }

                public @Nullable Duration getPeriod() {
                    return this.period;
                }

                public void setPeriod(@Nullable Duration period) {
                    this.period = period;
                }

                public boolean isAdaptive() {
                    return this.adaptive;
                }

                public void setAdaptive(boolean adaptive) {
                    this.adaptive = adaptive;
                }
            }
        }
    }

    public static enum ClientType {
        LETTUCE,
        JEDIS;

    }

    public static class Sentinel {
        private @Nullable String master;
        private @Nullable List<String> nodes;
        private @Nullable String username;
        private @Nullable String password;

        public @Nullable String getMaster() {
            return this.master;
        }

        public void setMaster(@Nullable String master) {
            this.master = master;
        }

        public @Nullable List<String> getNodes() {
            return this.nodes;
        }

        public void setNodes(@Nullable List<String> nodes) {
            this.nodes = nodes;
        }

        public @Nullable String getUsername() {
            return this.username;
        }

        public void setUsername(@Nullable String username) {
            this.username = username;
        }

        public @Nullable String getPassword() {
            return this.password;
        }

        public void setPassword(@Nullable String password) {
            this.password = password;
        }
    }

    public static class Cluster {
        private @Nullable List<String> nodes;
        private @Nullable Integer maxRedirects;

        public @Nullable List<String> getNodes() {
            return this.nodes;
        }

        public void setNodes(@Nullable List<String> nodes) {
            this.nodes = nodes;
        }

        public @Nullable Integer getMaxRedirects() {
            return this.maxRedirects;
        }

        public void setMaxRedirects(@Nullable Integer maxRedirects) {
            this.maxRedirects = maxRedirects;
        }
    }

    public static class Masterreplica {
        private @Nullable List<String> nodes;

        public @Nullable List<String> getNodes() {
            return this.nodes;
        }

        public void setNodes(@Nullable List<String> nodes) {
            this.nodes = nodes;
        }
    }

    public static class Pool {
        private @Nullable Boolean enabled;
        private int maxIdle = 8;
        private int minIdle;
        private int maxActive = 8;
        private Duration maxWait = Duration.ofMillis(-1L);
        private @Nullable Duration timeBetweenEvictionRuns;

        public @Nullable Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
        }

        public int getMaxIdle() {
            return this.maxIdle;
        }

        public void setMaxIdle(int maxIdle) {
            this.maxIdle = maxIdle;
        }

        public int getMinIdle() {
            return this.minIdle;
        }

        public void setMinIdle(int minIdle) {
            this.minIdle = minIdle;
        }

        public int getMaxActive() {
            return this.maxActive;
        }

        public void setMaxActive(int maxActive) {
            this.maxActive = maxActive;
        }

        public Duration getMaxWait() {
            return this.maxWait;
        }

        public void setMaxWait(Duration maxWait) {
            this.maxWait = maxWait;
        }

        public @Nullable Duration getTimeBetweenEvictionRuns() {
            return this.timeBetweenEvictionRuns;
        }

        public void setTimeBetweenEvictionRuns(@Nullable Duration timeBetweenEvictionRuns) {
            this.timeBetweenEvictionRuns = timeBetweenEvictionRuns;
        }
    }
}

