/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure;

import javax.net.ssl.SSLParameters;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.data.redis.autoconfigure.DataRedisConnectionConfiguration;
import org.springframework.boot.data.redis.autoconfigure.DataRedisConnectionDetails;
import org.springframework.boot.data.redis.autoconfigure.DataRedisProperties;
import org.springframework.boot.data.redis.autoconfigure.JedisClientConfigurationBuilderCustomizer;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.thread.Threading;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.RedisStaticMasterReplicaConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={GenericObjectPool.class, JedisConnection.class, Jedis.class})
@ConditionalOnMissingBean(value={RedisConnectionFactory.class})
@ConditionalOnProperty(name={"spring.data.redis.client-type"}, havingValue="jedis", matchIfMissing=true)
class JedisConnectionConfiguration
extends DataRedisConnectionConfiguration {
    JedisConnectionConfiguration(DataRedisProperties properties, ObjectProvider<RedisStandaloneConfiguration> standaloneConfigurationProvider, ObjectProvider<RedisSentinelConfiguration> sentinelConfiguration, ObjectProvider<RedisClusterConfiguration> clusterConfiguration, ObjectProvider<RedisStaticMasterReplicaConfiguration> masterReplicaConfiguration, DataRedisConnectionDetails connectionDetails) {
        super(properties, connectionDetails, standaloneConfigurationProvider, sentinelConfiguration, clusterConfiguration, masterReplicaConfiguration);
    }

    @Bean
    @ConditionalOnThreading(value=Threading.PLATFORM)
    JedisConnectionFactory redisConnectionFactory(ObjectProvider<JedisClientConfigurationBuilderCustomizer> builderCustomizers) {
        return this.createJedisConnectionFactory(builderCustomizers);
    }

    @Bean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    JedisConnectionFactory redisConnectionFactoryVirtualThreads(ObjectProvider<JedisClientConfigurationBuilderCustomizer> builderCustomizers) {
        JedisConnectionFactory factory = this.createJedisConnectionFactory(builderCustomizers);
        SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor("redis-");
        executor.setVirtualThreads(true);
        factory.setExecutor((AsyncTaskExecutor)executor);
        return factory;
    }

    private JedisConnectionFactory createJedisConnectionFactory(ObjectProvider<JedisClientConfigurationBuilderCustomizer> builderCustomizers) {
        JedisClientConfiguration clientConfiguration = this.getJedisClientConfiguration(builderCustomizers);
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case DataRedisConnectionConfiguration.Mode.STANDALONE -> new JedisConnectionFactory(this.getStandaloneConfig(), clientConfiguration);
            case DataRedisConnectionConfiguration.Mode.CLUSTER -> {
                RedisClusterConfiguration clusterConfiguration = this.getClusterConfiguration();
                Assert.state((clusterConfiguration != null ? 1 : 0) != 0, (String)"'clusterConfiguration' must not be null");
                yield new JedisConnectionFactory(clusterConfiguration, clientConfiguration);
            }
            case DataRedisConnectionConfiguration.Mode.SENTINEL -> {
                RedisSentinelConfiguration sentinelConfig = this.getSentinelConfig();
                Assert.state((sentinelConfig != null ? 1 : 0) != 0, (String)"'sentinelConfig' must not be null");
                yield new JedisConnectionFactory(sentinelConfig, clientConfiguration);
            }
            case DataRedisConnectionConfiguration.Mode.MASTER_REPLICA -> throw new IllegalStateException("'masterReplicaConfig' is not supported by Jedis");
        };
    }

    private JedisClientConfiguration getJedisClientConfiguration(ObjectProvider<JedisClientConfigurationBuilderCustomizer> builderCustomizers) {
        String url;
        JedisClientConfiguration.JedisClientConfigurationBuilder builder = this.applyProperties(JedisClientConfiguration.builder());
        this.applySslIfNeeded(builder);
        DataRedisProperties.Pool pool = this.getProperties().getJedis().getPool();
        if (this.isPoolEnabled(pool)) {
            this.applyPooling(pool, builder);
        }
        if (StringUtils.hasText((String)(url = this.getProperties().getUrl()))) {
            this.customizeConfigurationFromUrl(builder, url);
        }
        builderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    private JedisClientConfiguration.JedisClientConfigurationBuilder applyProperties(JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        PropertyMapper map = PropertyMapper.get();
        map.from((Object)this.getProperties().getTimeout()).to(arg_0 -> ((JedisClientConfiguration.JedisClientConfigurationBuilder)builder).readTimeout(arg_0));
        map.from((Object)this.getProperties().getConnectTimeout()).to(arg_0 -> ((JedisClientConfiguration.JedisClientConfigurationBuilder)builder).connectTimeout(arg_0));
        map.from((Object)this.getProperties().getClientName()).whenHasText().to(arg_0 -> ((JedisClientConfiguration.JedisClientConfigurationBuilder)builder).clientName(arg_0));
        return builder;
    }

    private void applySslIfNeeded(JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        SslBundle sslBundle = this.getSslBundle();
        if (sslBundle == null) {
            return;
        }
        JedisClientConfiguration.JedisSslClientConfigurationBuilder sslBuilder = builder.useSsl();
        sslBuilder.sslSocketFactory(sslBundle.createSslContext().getSocketFactory());
        SslOptions sslOptions = sslBundle.getOptions();
        SSLParameters sslParameters = new SSLParameters();
        PropertyMapper map = PropertyMapper.get();
        map.from((Object)sslOptions.getCiphers()).to(sslParameters::setCipherSuites);
        map.from((Object)sslOptions.getEnabledProtocols()).to(sslParameters::setProtocols);
        sslBuilder.sslParameters(sslParameters);
    }

    private void applyPooling(DataRedisProperties.Pool pool, JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        builder.usePooling().poolConfig((GenericObjectPoolConfig)this.jedisPoolConfig(pool));
    }

    private JedisPoolConfig jedisPoolConfig(DataRedisProperties.Pool pool) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(pool.getMaxActive());
        config.setMaxIdle(pool.getMaxIdle());
        config.setMinIdle(pool.getMinIdle());
        if (pool.getTimeBetweenEvictionRuns() != null) {
            config.setTimeBetweenEvictionRuns(pool.getTimeBetweenEvictionRuns());
        }
        if (pool.getMaxWait() != null) {
            config.setMaxWait(pool.getMaxWait());
        }
        return config;
    }

    private void customizeConfigurationFromUrl(JedisClientConfiguration.JedisClientConfigurationBuilder builder, String url) {
        if (this.urlUsesSsl(url)) {
            builder.useSsl();
        }
    }
}

