/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.health;

import java.util.Properties;
import org.springframework.boot.health.contributor.Health;
import org.springframework.data.redis.connection.ClusterInfo;

final class RedisHealth {
    private RedisHealth() {
    }

    static Health.Builder up(Health.Builder builder, Properties info) {
        builder.withDetail("version", (Object)info.getProperty("redis_version"));
        return builder.up();
    }

    static Health.Builder fromClusterInfo(Health.Builder builder, ClusterInfo clusterInfo) {
        builder.withDetail("cluster_size", (Object)clusterInfo.getClusterSize());
        builder.withDetail("slots_up", (Object)clusterInfo.getSlotsOk());
        builder.withDetail("slots_fail", (Object)clusterInfo.getSlotsFail());
        if ("fail".equalsIgnoreCase(clusterInfo.getState())) {
            return builder.down();
        }
        return builder.up();
    }
}

