/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.mongodb.autoconfigure;

import com.mongodb.ClientSessionOptions;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.util.Optional;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.data.mongodb.autoconfigure.MongoDataConfiguration;
import org.springframework.boot.mongodb.autoconfigure.MongoConnectionDetails;
import org.springframework.boot.mongodb.autoconfigure.MongoProperties;
import org.springframework.boot.mongodb.autoconfigure.MongoReactiveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.SimpleReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.gridfs.ReactiveGridFsOperations;
import org.springframework.data.mongodb.gridfs.ReactiveGridFsTemplate;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

@AutoConfiguration(after={MongoReactiveAutoConfiguration.class})
@ConditionalOnClass(value={MongoClient.class, ReactiveMongoTemplate.class})
@ConditionalOnBean(value={MongoClient.class})
@EnableConfigurationProperties(value={MongoProperties.class})
@Import(value={MongoDataConfiguration.class})
public class MongoReactiveDataAutoConfiguration {
    private final MongoConnectionDetails connectionDetails;

    MongoReactiveDataAutoConfiguration(MongoConnectionDetails connectionDetails) {
        this.connectionDetails = connectionDetails;
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveMongoDatabaseFactory.class})
    public SimpleReactiveMongoDatabaseFactory reactiveMongoDatabaseFactory(MongoClient mongo, MongoProperties properties) {
        String database = properties.getDatabase();
        if (database == null) {
            database = this.connectionDetails.getConnectionString().getDatabase();
        }
        return new SimpleReactiveMongoDatabaseFactory(mongo, database);
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveMongoOperations.class})
    public ReactiveMongoTemplate reactiveMongoTemplate(ReactiveMongoDatabaseFactory reactiveMongoDatabaseFactory, MongoConverter converter) {
        return new ReactiveMongoTemplate(reactiveMongoDatabaseFactory, converter);
    }

    @Bean
    @ConditionalOnMissingBean(value={DataBufferFactory.class})
    public DefaultDataBufferFactory dataBufferFactory() {
        return new DefaultDataBufferFactory();
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveGridFsOperations.class})
    public ReactiveGridFsTemplate reactiveGridFsTemplate(ReactiveMongoDatabaseFactory reactiveMongoDatabaseFactory, MappingMongoConverter mappingMongoConverter, DataBufferFactory dataBufferFactory) {
        return new ReactiveGridFsTemplate(dataBufferFactory, (ReactiveMongoDatabaseFactory)new GridFsReactiveMongoDatabaseFactory(reactiveMongoDatabaseFactory, this.connectionDetails), (MongoConverter)mappingMongoConverter, this.connectionDetails.getGridFs() != null ? this.connectionDetails.getGridFs().getBucket() : null);
    }

    static class GridFsReactiveMongoDatabaseFactory
    implements ReactiveMongoDatabaseFactory {
        private final ReactiveMongoDatabaseFactory delegate;
        private final MongoConnectionDetails connectionDetails;

        GridFsReactiveMongoDatabaseFactory(ReactiveMongoDatabaseFactory delegate, MongoConnectionDetails connectionDetails) {
            this.delegate = delegate;
            this.connectionDetails = connectionDetails;
        }

        public boolean hasCodecFor(Class<?> type) {
            return this.delegate.hasCodecFor(type);
        }

        public Mono<MongoDatabase> getMongoDatabase() throws DataAccessException {
            String gridFsDatabase = this.getGridFsDatabase(this.connectionDetails);
            if (StringUtils.hasText((String)gridFsDatabase)) {
                return this.delegate.getMongoDatabase(gridFsDatabase);
            }
            return this.delegate.getMongoDatabase();
        }

        private String getGridFsDatabase(MongoConnectionDetails connectionDetails) {
            return connectionDetails.getGridFs() != null ? connectionDetails.getGridFs().getDatabase() : null;
        }

        public Mono<MongoDatabase> getMongoDatabase(String dbName) throws DataAccessException {
            return this.delegate.getMongoDatabase(dbName);
        }

        public <T> Optional<Codec<T>> getCodecFor(Class<T> type) {
            return this.delegate.getCodecFor(type);
        }

        public PersistenceExceptionTranslator getExceptionTranslator() {
            return this.delegate.getExceptionTranslator();
        }

        public CodecRegistry getCodecRegistry() {
            return this.delegate.getCodecRegistry();
        }

        public Mono<ClientSession> getSession(ClientSessionOptions options) {
            return this.delegate.getSession(options);
        }

        public ReactiveMongoDatabaseFactory withSession(ClientSession session) {
            return this.delegate.withSession(session);
        }

        public boolean isTransactionActive() {
            return this.delegate.isTransactionActive();
        }
    }
}

