/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.jdbc.autoconfigure;

import java.util.function.Function;
import org.springframework.data.jdbc.core.dialect.DialectResolver;
import org.springframework.data.jdbc.core.dialect.JdbcDb2Dialect;
import org.springframework.data.jdbc.core.dialect.JdbcDialect;
import org.springframework.data.jdbc.core.dialect.JdbcH2Dialect;
import org.springframework.data.jdbc.core.dialect.JdbcHsqlDbDialect;
import org.springframework.data.jdbc.core.dialect.JdbcMariaDbDialect;
import org.springframework.data.jdbc.core.dialect.JdbcMySqlDialect;
import org.springframework.data.jdbc.core.dialect.JdbcOracleDialect;
import org.springframework.data.jdbc.core.dialect.JdbcPostgresDialect;
import org.springframework.data.jdbc.core.dialect.JdbcSqlServerDialect;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.util.Assert;

public enum DataJdbcDatabaseDialect {
    DB2((JdbcDialect)JdbcDb2Dialect.INSTANCE),
    H2((JdbcDialect)JdbcH2Dialect.INSTANCE),
    HSQL((JdbcDialect)JdbcHsqlDbDialect.INSTANCE),
    MARIA(JdbcMariaDbDialect.class),
    MYSQL(JdbcMySqlDialect.class),
    ORACLE((JdbcDialect)JdbcOracleDialect.INSTANCE),
    POSTGRESQL((JdbcDialect)JdbcPostgresDialect.INSTANCE),
    SQL_SERVER((JdbcDialect)JdbcSqlServerDialect.INSTANCE);

    private final Function<JdbcOperations, JdbcDialect> jdbcDialectResolver;

    private DataJdbcDatabaseDialect(Class<? extends JdbcDialect> jdbcDialectType) {
        this.jdbcDialectResolver = jdbc -> {
            JdbcDialect dialect = DialectResolver.getDialect((JdbcOperations)jdbc);
            Assert.isInstanceOf((Class)jdbcDialectType, (Object)dialect);
            return dialect;
        };
    }

    private DataJdbcDatabaseDialect(JdbcDialect jdbcDialect) {
        this.jdbcDialectResolver = jdbc -> jdbcDialect;
    }

    JdbcDialect getJdbcDialect(JdbcOperations jdbc) {
        return this.jdbcDialectResolver.apply(jdbc);
    }
}

