/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.couchbase.health;

import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.java.Cluster;
import org.springframework.boot.couchbase.health.CouchbaseHealth;
import org.springframework.boot.health.contributor.AbstractReactiveHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import reactor.core.publisher.Mono;

public class CouchbaseReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final Cluster cluster;

    public CouchbaseReactiveHealthIndicator(Cluster cluster) {
        super("Couchbase health check failed");
        this.cluster = cluster;
    }

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return this.cluster.reactive().diagnostics().map(diagnostics -> {
            new CouchbaseHealth((DiagnosticsResult)diagnostics).applyTo(builder);
            return builder.build();
        });
    }
}

