/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.couchbase.health;

import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.java.Cluster;
import org.springframework.boot.couchbase.health.CouchbaseHealth;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.util.Assert;

public class CouchbaseHealthIndicator
extends AbstractHealthIndicator {
    private final Cluster cluster;

    public CouchbaseHealthIndicator(Cluster cluster) {
        super("Couchbase health check failed");
        Assert.notNull((Object)cluster, (String)"'cluster' must not be null");
        this.cluster = cluster;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        DiagnosticsResult diagnostics = this.cluster.diagnostics();
        new CouchbaseHealth(diagnostics).applyTo(builder);
    }
}

