/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.options;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.springframework.boot.cli.command.options.OptionHelp;
import org.springframework.boot.cli.command.status.ExitStatus;

public class OptionHandler {
    private final Function<String, String> argumentProcessor;
    private OptionParser parser;
    private String help;
    private Collection<OptionHelp> optionHelp;

    public OptionHandler() {
        this(Function.identity());
    }

    public OptionHandler(Function<String, String> argumentProcessor) {
        this.argumentProcessor = argumentProcessor;
    }

    public OptionSpecBuilder option(String name, String description) {
        return this.getParser().accepts(name, description);
    }

    public OptionSpecBuilder option(List<String> aliases, String description) {
        return this.getParser().acceptsAll(aliases, description);
    }

    public OptionParser getParser() {
        if (this.parser == null) {
            this.parser = new OptionParser();
            this.options();
        }
        return this.parser;
    }

    protected void options() {
    }

    public final ExitStatus run(String ... args) throws Exception {
        String[] argsToUse = (String[])args.clone();
        for (int i = 0; i < argsToUse.length; ++i) {
            if ("-cp".equals(argsToUse[i])) {
                argsToUse[i] = "--cp";
            }
            argsToUse[i] = this.argumentProcessor.apply(argsToUse[i]);
        }
        OptionSet options = this.getParser().parse(argsToUse);
        return this.run(options);
    }

    protected ExitStatus run(OptionSet options) throws Exception {
        return ExitStatus.OK;
    }

    public String getHelp() {
        if (this.help == null) {
            this.getParser().formatHelpWith((HelpFormatter)new BuiltinHelpFormatter(80, 2));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                this.getParser().printHelpOn((OutputStream)out);
            }
            catch (IOException ex) {
                return "Help not available";
            }
            this.help = ((Object)out).toString().replace(" --cp ", " -cp  ");
        }
        return this.help;
    }

    public Collection<OptionHelp> getOptionsHelp() {
        if (this.optionHelp == null) {
            OptionHelpFormatter formatter = new OptionHelpFormatter();
            this.getParser().formatHelpWith((HelpFormatter)formatter);
            try {
                this.getParser().printHelpOn((OutputStream)new ByteArrayOutputStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.optionHelp = formatter.getOptionHelp();
        }
        return this.optionHelp;
    }

    private static final class OptionHelpFormatter
    implements HelpFormatter {
        private final List<OptionHelp> help = new ArrayList<OptionHelp>();

        private OptionHelpFormatter() {
        }

        public String format(Map<String, ? extends OptionDescriptor> options) {
            Comparator<OptionDescriptor> comparator = Comparator.comparing(optionDescriptor -> (String)optionDescriptor.options().iterator().next());
            TreeSet<OptionDescriptor> sorted = new TreeSet<OptionDescriptor>(comparator);
            sorted.addAll(options.values());
            for (OptionDescriptor descriptor : sorted) {
                if (descriptor.representsNonOptions()) continue;
                this.help.add(new OptionHelpAdapter(descriptor));
            }
            return "";
        }

        Collection<OptionHelp> getOptionHelp() {
            return Collections.unmodifiableList(this.help);
        }
    }

    private static class OptionHelpAdapter
    implements OptionHelp {
        private final Set<String> options = new LinkedHashSet<String>();
        private final String description;

        OptionHelpAdapter(OptionDescriptor descriptor) {
            for (String option : descriptor.options()) {
                String prefix = option.length() != 1 ? "--" : "-";
                this.options.add(prefix + option);
            }
            if (this.options.contains("--cp")) {
                this.options.remove("--cp");
                this.options.add("-cp");
            }
            this.description = descriptor.description();
        }

        @Override
        public Set<String> getOptions() {
            return this.options;
        }

        @Override
        public String getUsageHelp() {
            return this.description;
        }
    }
}

