/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.boot.cli.command.AbstractCommand;
import org.springframework.boot.cli.command.Command;
import org.springframework.boot.cli.command.CommandRunner;
import org.springframework.boot.cli.command.HelpExample;
import org.springframework.boot.cli.command.NoHelpCommandArgumentsException;
import org.springframework.boot.cli.command.NoSuchCommandException;
import org.springframework.boot.cli.command.core.HintCommand;
import org.springframework.boot.cli.command.options.OptionHelp;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.util.Log;

public class HelpCommand
extends AbstractCommand {
    private final CommandRunner commandRunner;

    public HelpCommand(CommandRunner commandRunner) {
        super("help", "Get help on commands");
        this.commandRunner = commandRunner;
    }

    @Override
    public String getUsageHelp() {
        return "command";
    }

    @Override
    public String getHelp() {
        return null;
    }

    @Override
    public Collection<OptionHelp> getOptionsHelp() {
        ArrayList<OptionHelp> help = new ArrayList<OptionHelp>();
        for (final Command command : this.commandRunner) {
            if (!this.isHelpShown(command)) continue;
            help.add(new OptionHelp(){
                final /* synthetic */ HelpCommand this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Set<String> getOptions() {
                    return Collections.singleton(command.getName());
                }

                @Override
                public String getUsageHelp() {
                    return command.getDescription();
                }
            });
        }
        return help;
    }

    private boolean isHelpShown(Command command) {
        return !(command instanceof HelpCommand) && !(command instanceof HintCommand);
    }

    @Override
    public ExitStatus run(String ... args) throws Exception {
        if (args.length == 0) {
            throw new NoHelpCommandArgumentsException();
        }
        String commandName = args[0];
        for (Command command : this.commandRunner) {
            Collection<HelpExample> examples;
            if (!command.getName().equals(commandName)) continue;
            Log.info(this.commandRunner.getName() + command.getName() + " - " + command.getDescription());
            Log.info("");
            if (command.getUsageHelp() != null) {
                Log.info("usage: " + this.commandRunner.getName() + command.getName() + " " + command.getUsageHelp());
                Log.info("");
            }
            if (command.getHelp() != null) {
                Log.info(command.getHelp());
            }
            if ((examples = command.getExamples()) != null) {
                Log.info(examples.size() != 1 ? "examples:" : "example:");
                Log.info("");
                for (HelpExample example : examples) {
                    Log.info("    " + example.getDescription() + ":");
                    Log.info("        $ " + example.getExample());
                    Log.info("");
                }
                Log.info("");
            }
            return ExitStatus.OK;
        }
        throw new NoSuchCommandException(commandName);
    }
}

