/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cassandra.autoconfigure.health;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cassandra.health.CassandraDriverHealthIndicator;
import org.springframework.boot.cassandra.health.CassandraDriverReactiveHealthIndicator;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

class CassandraHealthContributorConfigurations {
    CassandraHealthContributorConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={CqlSession.class})
    static class CassandraReactiveDriverConfiguration
    extends CompositeReactiveHealthContributorConfiguration<CassandraDriverReactiveHealthIndicator, CqlSession> {
        CassandraReactiveDriverConfiguration() {
            super(CassandraDriverReactiveHealthIndicator::new);
        }

        @Bean
        @ConditionalOnMissingBean(name={"cassandraHealthIndicator", "cassandraHealthContributor"})
        ReactiveHealthContributor cassandraHealthContributor(Map<String, CqlSession> sessions) {
            return (ReactiveHealthContributor)this.createContributor(sessions);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={CqlSession.class})
    static class CassandraDriverConfiguration
    extends CompositeHealthContributorConfiguration<CassandraDriverHealthIndicator, CqlSession> {
        CassandraDriverConfiguration() {
            super(CassandraDriverHealthIndicator::new);
        }

        @Bean
        @ConditionalOnMissingBean(name={"cassandraHealthIndicator", "cassandraHealthContributor"})
        HealthContributor cassandraHealthContributor(ConfigurableListableBeanFactory beanFactory) {
            return (HealthContributor)this.createContributor(beanFactory, CqlSession.class);
        }
    }
}

