/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.elasticsearch.jest;

import com.google.gson.Gson;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.time.Duration;
import org.apache.http.HttpHost;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.jest.HttpClientConfigBuilderCustomizer;
import org.springframework.boot.autoconfigure.elasticsearch.jest.JestProperties;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JestClient.class})
@EnableConfigurationProperties(value={JestProperties.class})
@AutoConfigureAfter(value={GsonAutoConfiguration.class})
@Deprecated
public class JestAutoConfiguration {
    @Bean(destroyMethod="shutdownClient")
    @ConditionalOnMissingBean
    public JestClient jestClient(JestProperties properties, ObjectProvider<Gson> gson, ObjectProvider<HttpClientConfigBuilderCustomizer> builderCustomizers) {
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(this.createHttpClientConfig(properties, gson, builderCustomizers));
        return factory.getObject();
    }

    protected HttpClientConfig createHttpClientConfig(JestProperties properties, ObjectProvider<Gson> gson, ObjectProvider<HttpClientConfigBuilderCustomizer> builderCustomizers) {
        HttpClientConfig.Builder builder = new HttpClientConfig.Builder(properties.getUris());
        PropertyMapper map = PropertyMapper.get();
        map.from(properties::getUsername).whenHasText().to(username -> builder.defaultCredentials(username, properties.getPassword()));
        JestProperties.Proxy proxy = properties.getProxy();
        map.from(proxy::getHost).whenHasText().to(host -> {
            Assert.notNull((Object)proxy.getPort(), (String)"Proxy port must not be null");
            builder.proxy(new HttpHost(host, proxy.getPort().intValue()));
        });
        map.from(() -> gson.getIfUnique()).whenNonNull().to(x$0 -> builder.gson(x$0));
        map.from(properties::isMultiThreaded).to(x$0 -> builder.multiThreaded(x$0));
        map.from(properties::getConnectionTimeout).whenNonNull().asInt(Duration::toMillis).to(x$0 -> builder.connTimeout(x$0));
        map.from(properties::getReadTimeout).whenNonNull().asInt(Duration::toMillis).to(x$0 -> builder.readTimeout(x$0));
        builderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }
}

