/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource.reactive;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.reactive.ReactiveOAuth2ResourceServerJwkConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.resource.reactive.ReactiveOAuth2ResourceServerOpaqueTokenConfiguration;
import org.springframework.boot.autoconfigure.security.reactive.ReactiveSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.security.reactive.ReactiveUserDetailsServiceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={ReactiveSecurityAutoConfiguration.class, ReactiveUserDetailsServiceAutoConfiguration.class})
@EnableConfigurationProperties(value={OAuth2ResourceServerProperties.class})
@ConditionalOnClass(value={EnableWebFluxSecurity.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class ReactiveOAuth2ResourceServerAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={BearerTokenAuthenticationToken.class, ReactiveOpaqueTokenIntrospector.class})
    @Import(value={ReactiveOAuth2ResourceServerOpaqueTokenConfiguration.OpaqueTokenIntrospectionClientConfiguration.class, ReactiveOAuth2ResourceServerOpaqueTokenConfiguration.WebSecurityConfiguration.class})
    static class OpaqueTokenConfiguration {
        OpaqueTokenConfiguration() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={BearerTokenAuthenticationToken.class, ReactiveJwtDecoder.class})
    @Import(value={ReactiveOAuth2ResourceServerJwkConfiguration.JwtConfiguration.class, ReactiveOAuth2ResourceServerJwkConfiguration.WebSecurityConfiguration.class})
    static class JwtConfiguration {
        JwtConfiguration() {
        }
    }
}

