/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.spring.cache.CacheBuilder;
import com.couchbase.client.spring.cache.CouchbaseCacheManager;
import java.time.Duration;
import java.util.List;
import org.springframework.boot.autoconfigure.cache.CacheCondition;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizers;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Bucket.class, CouchbaseCacheManager.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@ConditionalOnSingleCandidate(value=Bucket.class)
@Conditional(value={CacheCondition.class})
public class CouchbaseCacheConfiguration {
    @Bean
    public CouchbaseCacheManager cacheManager(CacheProperties cacheProperties, CacheManagerCustomizers customizers, Bucket bucket) {
        List<String> cacheNames = cacheProperties.getCacheNames();
        CacheBuilder builder = CacheBuilder.newInstance((Bucket)bucket);
        CacheProperties.Couchbase couchbase = cacheProperties.getCouchbase();
        PropertyMapper.get().from(couchbase::getExpiration).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((CacheBuilder)builder).withExpiration(arg_0));
        String[] names = StringUtils.toStringArray(cacheNames);
        CouchbaseCacheManager cacheManager = new CouchbaseCacheManager(builder, names);
        return customizers.customize(cacheManager);
    }
}

